/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.template;

import cn.jants.common.annotation.boot.ViewConfiguration;
import cn.jants.common.enums.LoadType;
import cn.jants.common.utils.StrUtil;
import cn.jants.restful.render.ModelAndView;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public class VelocityTpl {
    private VelocityEngine velocityEngine = new VelocityEngine();
    private String tplDir = "";
    private String suffix = "";

    public VelocityTpl(ViewConfiguration viewConfiguration) {
        if (viewConfiguration.loadType() == LoadType.FilePath) {
            this.velocityEngine.setProperty("file.resource.loader.path", (Object)viewConfiguration.loadPath());
        } else {
            this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
            this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            this.velocityEngine.setProperty("classpath.resource.loader.cache", (Object)true);
            this.velocityEngine.setProperty("classpath.resource.loader.modification.check.interval", (Object)viewConfiguration.updateDelay());
            this.tplDir = viewConfiguration.loadPath();
        }
        this.velocityEngine.setProperty("input.encoding", (Object)"UTF-8");
        this.velocityEngine.setProperty("output.encoding", (Object)"UTF-8");
        this.velocityEngine.init();
        this.suffix = viewConfiguration.suffix();
    }

    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setTplDir(String tplDir) {
        this.tplDir = tplDir;
    }

    public void clearCache() {
    }

    private void render(String viewName, ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        Template template = null;
        VelocityContext ctx = new VelocityContext();
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            ctx.put(attributeName, request.getAttribute(attributeName));
        }
        if (viewName != null) {
            template = this.velocityEngine.getTemplate(this.tplDir.concat(StrUtil.setFirstInitial(viewName, Character.valueOf('/'))).concat(this.suffix));
        } else if (modelAndView != null) {
            template = this.velocityEngine.getTemplate(this.tplDir.concat(StrUtil.setFirstInitial(modelAndView.getView(), Character.valueOf('/'))).concat(this.suffix));
            Map model = modelAndView.getModel();
            if (model != null) {
                Set sets = model.entrySet();
                for (Map.Entry entry : sets) {
                    ctx.put((String)entry.getKey(), entry.getValue());
                }
            }
        }
        try {
            template.merge((Context)ctx, (Writer)response.getWriter());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void render(String viewName, HttpServletRequest request, HttpServletResponse response) {
        this.render(viewName, null, request, response);
    }

    public void render(ModelAndView modelAndView, HttpServletRequest request, HttpServletResponse response) {
        this.render(null, modelAndView, request, response);
    }
}

