/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.sqlmap;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ExpressionSyntaxException;
import ognl.Node;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.OgnlParser;
import ognl.ParseException;
import ognl.TokenMgrError;

public class OgnlCache {
    private static final Map<String, Node> EXPRESSION_CACHE = new ConcurrentHashMap<String, Node>();

    public static Object getValue(String expression, Object root) {
        try {
            return Ognl.getValue((Object)OgnlCache.parseExpression(expression), (Object)root);
        }
        catch (OgnlException e) {
            throw new IllegalArgumentException("Error evaluating expression '" + expression + "'. Cause: " + e.getMessage());
        }
    }

    private static Object parseExpression(String expression) throws OgnlException {
        try {
            Node node = EXPRESSION_CACHE.get(expression);
            if (node == null) {
                node = new OgnlParser((Reader)new StringReader(expression)).topLevelExpression();
                EXPRESSION_CACHE.put(expression, node);
            }
            return node;
        }
        catch (ParseException e) {
            throw new ExpressionSyntaxException(expression, (Throwable)e);
        }
        catch (TokenMgrError e) {
            throw new ExpressionSyntaxException(expression, (Throwable)e);
        }
    }
}

