/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.pay.wx;

import cn.jants.common.bean.Log;
import cn.jants.common.utils.StrEncryptUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class Sign {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String md5Sign(TreeMap map, String payKey) {
        String stringSignTemp = Sign.pj(map);
        if (payKey != null) {
            stringSignTemp = stringSignTemp + "&key=" + payKey;
        }
        Log.debug("\u7b7e\u540dStr > {}", stringSignTemp);
        return StrEncryptUtil.md5(stringSignTemp).toUpperCase();
    }

    public static String sha1(String str) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(str.getBytes());
            byte[] bytes = messageDigest.digest();
            int len = bytes.length;
            StringBuilder buf = new StringBuilder(len * 2);
            for (int j = 0; j < len; ++j) {
                buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
                buf.append(HEX_DIGITS[bytes[j] & 0xF]);
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String pj(TreeMap map) {
        StringBuffer sb = new StringBuffer();
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append(key + "=" + value + "&");
        }
        String stringSignTemp = String.valueOf(sb);
        return stringSignTemp.substring(0, stringSignTemp.length() - 1);
    }

    public static String hmacSha256Sign(TreeMap map, String payKey) {
        String stringSignTemp = Sign.pj(map);
        if (payKey != null) {
            stringSignTemp = stringSignTemp + "&key=" + payKey;
        }
        Log.debug("\u7b7e\u540dStr > {}", stringSignTemp);
        return Sign.sha256HMAC(stringSignTemp, payKey).toUpperCase();
    }

    private static String sha256HMAC(String data, String key) {
        try {
            Mac sha256HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            sha256HMAC.init(secretKey);
            byte[] array = sha256HMAC.doFinal(data.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder();
            for (byte item : array) {
                sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
            }
            return sb.toString().toUpperCase();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }
}

