/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.orm;

import cn.jants.common.bean.JsonMap;
import cn.jants.common.bean.Page;
import cn.jants.plugin.db.Db;
import cn.jants.plugin.orm.Conditions;
import cn.jants.plugin.orm.SqlParams;
import cn.jants.plugin.orm.TableBean;
import cn.jants.plugin.orm.TableMapper;
import cn.jants.plugin.orm.enums.Condition;
import java.util.List;

public class Criteria<T>
extends Conditions {
    private Db db;
    private Class<T> cls;

    public Criteria(Class<T> cls, Db db) {
        this.cls = cls;
        this.db = db;
    }

    public void save(Object obj) {
        SqlParams sqlParams = TableMapper.createInsertSql(obj);
        this.db.insert(sqlParams.getSql(), sqlParams.getParams());
    }

    public Long saveReturnKey(Object obj) {
        SqlParams sqlParams = TableMapper.createInsertSql(obj);
        return this.db.insertReturnKey(sqlParams.getSql(), sqlParams.getParams());
    }

    public Integer delete() {
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createDeleteSql(tableBean, this);
        int result = this.db.update(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result;
    }

    public Integer deleteById(Object id) {
        if (id == null) {
            throw new RuntimeException("\u4f20\u9012\u7684\u4e3b\u952e\u4e3aNULL");
        }
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        this.and(tableBean.getPrimaryKey(), Condition.EQ, id);
        SqlParams sqlParams = TableMapper.createDeleteSql(tableBean, this);
        int result = this.db.update(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result;
    }

    public Integer update(Object obj) {
        SqlParams sqlParams = TableMapper.createUpdateSql(obj, this);
        int result = this.db.update(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result;
    }

    public T findById(Object id) {
        if (id == null) {
            throw new RuntimeException("\u4f20\u9012\u7684\u4e3b\u952e\u4e3aNULL");
        }
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        this.and(tableBean.getPrimaryKey(), Condition.EQ, id);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        T result = this.db.query(sqlParams.getSql(), this.cls, sqlParams.getParams());
        this.clear();
        return result;
    }

    public JsonMap findMapById(Object id) {
        if (id == null) {
            throw new RuntimeException("\u4f20\u9012\u7684\u4e3b\u952e\u4e3aNULL");
        }
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        this.and(tableBean.getPrimaryKey(), Condition.EQ, id);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        JsonMap result = this.db.query(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result;
    }

    public T find() {
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        T result = this.db.query(sqlParams.getSql(), this.cls, sqlParams.getParams());
        this.clear();
        return result;
    }

    public JsonMap findMap() {
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        JsonMap result = this.db.query(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result;
    }

    public Integer count() {
        this.label("count(0)");
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        JsonMap result = this.db.query(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result.getInt("count", 0);
    }

    public List<T> findList() {
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        List<T> result = this.db.list(sqlParams.getSql(), this.cls, sqlParams.getParams());
        this.clear();
        return result;
    }

    public List<JsonMap> findMapList() {
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        List<JsonMap> result = this.db.list(sqlParams.getSql(), sqlParams.getParams());
        this.clear();
        return result;
    }

    public Page findPage(Integer index, Integer size) {
        TableBean tableBean = TableMapper.findTableBean(this.cls);
        SqlParams sqlParams = TableMapper.createQuerySql(tableBean, this);
        Page<T> result = this.db.page(sqlParams.getSql(), this.cls, index, size, sqlParams.getParams());
        this.clear();
        return result;
    }
}

