/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.plugin.jms;

import cn.jants.common.annotation.service.Service;
import cn.jants.core.module.ServiceManager;
import cn.jants.core.utils.GenerateUtil;
import cn.jants.plugin.jms.ConsumerListener;
import cn.jants.plugin.jms.JmsConsumer;
import cn.jants.plugin.jms.JmsListener;
import java.util.List;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;

public class ConsumerManager {
    private String brokenUrl;
    private String username;
    private String password;
    private List<Class<?>> consumers;

    public ConsumerManager(String brokenUrl, String username, String password, List<Class<?>> consumers) {
        this.brokenUrl = brokenUrl;
        this.username = username;
        this.password = password;
        this.consumers = consumers;
    }

    public void start() {
        try {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.username, this.password, this.brokenUrl);
            Connection connection = connectionFactory.createConnection();
            connection.start();
            Session session = connection.createSession(Boolean.FALSE.booleanValue(), 1);
            for (Class<?> consumerCls : this.consumers) {
                JmsListener jmsListener = consumerCls.getAnnotation(JmsListener.class);
                Object target = consumerCls.newInstance();
                if (!(target instanceof JmsConsumer)) continue;
                if (consumerCls.getAnnotation(Service.class) != null) {
                    String serName = consumerCls.getName();
                    String key = GenerateUtil.createServiceKey(serName);
                    target = ServiceManager.getService(key);
                }
                String dest = jmsListener.destination();
                Queue destination = session.createQueue(dest);
                MessageConsumer consumer = session.createConsumer((Destination)destination);
                consumer.setMessageListener((MessageListener)new ConsumerListener(dest, target));
            }
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

