/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.utils;

import cn.jants.common.bean.Log;
import cn.jants.common.enums.StartMode;
import cn.jants.common.utils.PathUtil;
import cn.jants.core.context.AppConstant;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ScanUtil {
    private static List<Class> CLASSES = null;

    public static List<Class<?>> findScanClass(String[] packages, Class<? extends Annotation> annotationCls) {
        ArrayList result = new ArrayList();
        if (CLASSES == null) {
            CLASSES = new ArrayList<Class>(100);
        }
        if (PathUtil.isJarMode()) {
            AppConstant.START_MODE = StartMode.JAR;
            try {
                JarFile jarFile = new JarFile(PathUtil.getJarPath(AppConstant.LOAD_CLASS));
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String clsName;
                    JarEntry entry = entries.nextElement();
                    String strCls = entry.getName();
                    if (!strCls.endsWith(".class") || !ScanUtil.check(clsName = strCls.substring(0, strCls.lastIndexOf(".")).replace("/", "."), packages)) continue;
                    Class<?> cls = Class.forName(clsName);
                    CLASSES.add(cls);
                    Annotation anno = cls.getAnnotation(annotationCls);
                    if (anno == null) continue;
                    result.add(cls);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            AppConstant.START_MODE = StartMode.WAR;
            String classPath = PathUtil.getClassPath();
            if (CLASSES.size() == 0) {
                ScanUtil.loadPathClass(classPath, packages);
            }
            for (Class cls : CLASSES) {
                if (cls.getAnnotation(annotationCls) == null) continue;
                result.add(cls);
            }
        }
        Log.info("mode: {}", new Object[]{AppConstant.START_MODE});
        return result;
    }

    private static void loadPathClass(String filePath, String[] packages) {
        File dir = new File(filePath);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                String path = file.getPath();
                if (!file.isDirectory() && path.endsWith(".class")) {
                    Class<?> aClass;
                    String className = path.split("classes\\" + File.separator)[1].replace(File.separator, ".");
                    if (!ScanUtil.check(className, packages)) continue;
                    try {
                        aClass = Class.forName(className.substring(0, className.lastIndexOf(".")));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new RuntimeException("\u5305\u626b\u63cf, class.forname \u52a0\u8f7d\u51fa\u73b0\u5f02\u5e38!");
                    }
                    CLASSES.add(aClass);
                    continue;
                }
                ScanUtil.loadPathClass(path, packages);
            }
        }
    }

    private static boolean check(String clsName, String[] packages) {
        for (String pg : packages) {
            if (!clsName.startsWith(pg)) continue;
            return true;
        }
        return false;
    }

    public static void clear() {
        CLASSES.clear();
    }
}

