/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.startup;

import cn.jants.common.bean.Log;
import cn.jants.common.utils.StrUtil;
import cn.jants.core.context.AntsFilter;
import cn.jants.core.startup.CommonProperty;
import cn.jants.core.startup.assembly.FilterAssembly;
import cn.jants.core.startup.assembly.ServletAssembly;
import cn.jants.core.startup.servlet.IndexServlet;
import cn.jants.core.startup.servlet.LogoServlet;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class Jetty
extends CommonProperty {
    public Jetty(String webApp, int port, String contextPath, Class loadClass, boolean isOpen) {
        super(webApp, port, contextPath, loadClass, isOpen);
    }

    @Override
    public Jetty start() {
        Server server = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(this.port);
        server.addConnector((Connector)connector);
        WebAppContext webAppContext = new WebAppContext();
        webAppContext.setContextPath(this.contextPath);
        webAppContext.setBaseResource(Resource.newClassPathResource((String)""));
        webAppContext.setClassLoader(Thread.currentThread().getContextClassLoader());
        webAppContext.setThrowUnavailableOnStartupException(true);
        webAppContext.setConfigurationDiscovered(true);
        webAppContext.setParentLoaderPriority(true);
        server.setHandler((Handler)webAppContext);
        webAppContext.addServlet(new ServletHolder((Servlet)new IndexServlet()), "");
        webAppContext.addServlet(new ServletHolder((Servlet)new LogoServlet()), "/ants-logo");
        if (StrUtil.notNull(this.servlets)) {
            for (ServletAssembly servlet : this.servlets) {
                webAppContext.addServlet(new ServletHolder((Servlet)servlet.getServlet()), servlet.getUrlPattern());
            }
        }
        FilterHolder filterHolder = new FilterHolder((Filter)new AntsFilter());
        filterHolder.setInitParameter("loadClass", this.loadClass.getName());
        webAppContext.addFilter(filterHolder, "/*", EnumSet.allOf(DispatcherType.class));
        MimeTypes mimeTypes = new MimeTypes();
        mimeTypes.addMimeMapping("woff", "application/x-font-woff");
        mimeTypes.addMimeMapping("woff2", "application/x-font-woff");
        mimeTypes.addMimeMapping("ttf", "application/octet-stream");
        mimeTypes.addMimeMapping("otf", "application/octet-stream");
        webAppContext.setMimeTypes(mimeTypes);
        if (StrUtil.notNull(this.filters)) {
            for (FilterAssembly filter : this.filters) {
                webAppContext.addFilter(new FilterHolder(filter.getFilter()), filter.getFilterName(), EnumSet.allOf(DispatcherType.class));
            }
        }
        try {
            Log.debug("jetty is success!", new Object[0]);
            server.start();
            if (this.isOpen) {
                this.openBrowser();
            }
            server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public static Jetty run(Class loadClass) {
        return new Jetty(null, 8080, "", loadClass, false).start();
    }

    public static Jetty run(Class loadClass, int port) {
        return new Jetty(null, port, "", loadClass, false).start();
    }

    public static Jetty run(Class loadClass, int port, boolean isOpen) {
        return new Jetty(null, port, "", loadClass, isOpen).start();
    }

    public static Jetty run(Class loadClass, String[] args) {
        int port = 8080;
        String contextPath = "/";
        if (args != null && args.length > 0) {
            port = Integer.parseInt(args[0]);
            contextPath = args[1] != null ? args[1] : "";
        }
        return new Jetty(null, port, contextPath, loadClass, false).start();
    }

    public static Jetty run(Class loadClass, String contextPath) {
        return new Jetty(null, 8080, contextPath, loadClass, false).start();
    }

    public static Jetty run(Class loadClass, int port, String contextPath) {
        return new Jetty(null, port, contextPath, loadClass, false).start();
    }

    public static Jetty run(Class loadClass, String webApp, int port, String contextPath) {
        return new Jetty(webApp, port, contextPath, loadClass, false).start();
    }
}

