/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.proxy;

import cn.jants.common.annotation.service.Source;
import cn.jants.common.annotation.service.Tx;
import cn.jants.common.enums.DataSourceType;
import cn.jants.common.enums.TxLevel;
import cn.jants.plugin.db.Db;
import cn.jants.restful.bind.utils.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class TransactionManager {
    private List<Db> dbs;

    public TransactionManager(Object target, Method method) {
        Tx methodTx = method.getAnnotation(Tx.class);
        Tx classTx = target.getClass().getAnnotation(Tx.class);
        if (methodTx != null || classTx != null) {
            Field[] fields = target.getClass().getDeclaredFields();
            this.dbs = new ArrayList<Db>();
            for (Field field : fields) {
                if (field.getType() != Db.class) continue;
                Source source = field.getAnnotation(Source.class);
                TxLevel level = TxLevel.REPEATED_READ;
                if (methodTx != null) {
                    level = methodTx.value();
                } else if (classTx != null) {
                    level = classTx.value();
                }
                DataSource dataSource = DataSourceType.getDataSource(source);
                try {
                    ReflectionUtils.makeAccessible(field);
                    Db db = (Db)field.get(target);
                    String sourceName = source.value();
                    String sourceType = "[".concat(String.valueOf((Object)source.type())).concat("] \u6570\u636e\u6e90\u540d\u79f0\uff1a");
                    String tips = "".equals(sourceName) ? sourceType.concat("{\u9ed8\u8ba4} ") : sourceType.concat("{" + sourceName + "} ");
                    db.startTx(dataSource, tips, level);
                    this.dbs.add(db);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void commit() {
        if (this.dbs != null && this.dbs.size() != 0) {
            for (Db db : this.dbs) {
                try {
                    db.commit();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void rollback() {
        if (this.dbs != null && this.dbs.size() != 0) {
            for (Db db : this.dbs) {
                db.rollback();
            }
        }
    }
}

