/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.core.handler;

import cn.jants.common.bean.Log;
import cn.jants.common.enums.RequestMethod;
import cn.jants.common.enums.ResponseCode;
import cn.jants.core.context.AppConstant;
import cn.jants.core.ext.Handler;
import cn.jants.core.holder.ClientRequest;
import cn.jants.core.holder.ContextRequestManager;
import cn.jants.core.module.Constant;
import cn.jants.core.module.RequestMappingManager;
import cn.jants.restful.render.Json;
import cn.jants.restful.render.ModelAndView;
import cn.jants.restful.render.Resource;
import cn.jants.restful.render.View;
import cn.jants.restful.request.BindingParams;
import cn.jants.restful.request.MappingMatch;
import cn.jants.restful.request.RequestMappingBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.ReflectionUtils;

public class RenderHandler
implements Handler {
    private final List<RequestMappingBean> requestMappingManager = RequestMappingManager.getRequestMappingManager();
    private final Constant constant;

    public RenderHandler(Constant constant) {
        this.constant = constant;
    }

    @Override
    public boolean preHandler(String target, HttpServletRequest request, HttpServletResponse response) throws Exception {
        RequestMappingBean bean = MappingMatch.match(this.requestMappingManager, target);
        if (bean == null) {
            return true;
        }
        String type = request.getMethod();
        RequestMethod requestType = bean.getRequestType();
        if (requestType == null || type.equals(String.valueOf((Object)requestType))) {
            Field[] declaredFields;
            ContextRequestManager.set(new ClientRequest(request, response));
            Object[] args = BindingParams.bingingValidate(target, bean, request, response);
            Object object = bean.getObject();
            for (Field field : declaredFields = object.getClass().getDeclaredFields()) {
                if (field.getType() == HttpServletRequest.class) {
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(object, ContextRequestManager.get().getRequest());
                    continue;
                }
                if (field.getType() == HttpServletResponse.class) {
                    ReflectionUtils.makeAccessible((Field)field);
                    field.set(object, ContextRequestManager.get().getResponse());
                    continue;
                }
                if (field.getType() != HttpSession.class) continue;
                ReflectionUtils.makeAccessible((Field)field);
                field.set(object, ContextRequestManager.get().getSession());
            }
            Log.action(target, request, bean);
            Method method = bean.getMethod();
            method.setAccessible(true);
            Object data = method.invoke(bean.getProxy(), args);
            Class<?> returnType = method.getReturnType();
            ContextRequestManager.remove();
            String doc = request.getParameter("_doc");
            if (!AppConstant.DEBUG.booleanValue() || doc != null) {
                // empty if block
            }
            if (data != null) {
                if (returnType == String.class) {
                    if (String.valueOf(data).indexOf("redirect:") != -1) {
                        String rect = String.valueOf(data).split("redirect:")[1];
                        response.sendRedirect(request.getContextPath() + rect);
                        return true;
                    }
                    View.render(data, request, response);
                } else if (returnType == ModelAndView.class) {
                    View.render((ModelAndView)data, request, response);
                } else if (returnType == Resource.class) {
                    Resource res = (Resource)data;
                    res.render(request, response);
                } else if (returnType == Object.class) {
                    Json.writeJson(data, response, true);
                } else {
                    Json.writeJson(data, response, false);
                }
            }
        } else {
            Json.writeJson(Json.exception(ResponseCode.REQUEST_TYPE_ERROR), response);
        }
        return false;
    }
}

