/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import cn.jants.common.enums.EncType;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.tomcat.util.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrEncryptUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StrEncryptUtil.class);
    private static final String UTF_8 = "UTF-8";

    public static String md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encrypt(String password, EncType type, String str) {
        try {
            String encType = String.valueOf((Object)type);
            int len = StrEncryptUtil.keyLen(type);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(encType);
            keyGenerator.init(len, new SecureRandom(password.getBytes(UTF_8)));
            SecretKeySpec secretKey = new SecretKeySpec(password.getBytes(), encType);
            Cipher cipher = Cipher.getInstance(encType);
            cipher.init(1, secretKey);
            byte[] cipherByte = cipher.doFinal(str.getBytes(UTF_8));
            return Base64.encodeBase64String((byte[])cipherByte);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("{} \u52a0\u5bc6\u5f02\u5e38, \u52a0\u5bc6\u5b57\u7b26 > {}", (Object)type, (Object)str);
            return null;
        }
    }

    public static String decrypt(String password, EncType type, String str) {
        try {
            String encType = String.valueOf((Object)type);
            byte[] data = Base64.decodeBase64((byte[])str.getBytes(UTF_8));
            int len = StrEncryptUtil.keyLen(type);
            KeyGenerator keyGenerator = KeyGenerator.getInstance(encType);
            keyGenerator.init(len, new SecureRandom(password.getBytes(UTF_8)));
            SecretKeySpec secretKey = new SecretKeySpec(password.getBytes(), encType);
            Cipher cipher = Cipher.getInstance(encType);
            cipher.init(2, secretKey);
            byte[] bytes = cipher.doFinal(data);
            return new String(bytes, UTF_8);
        }
        catch (Exception e) {
            LOG.info("{} \u89e3\u5bc6\u5931\u8d25, \u89e3\u5bc6\u5b57\u7b26 > {}", (Object)type, (Object)str);
            return null;
        }
    }

    private static int keyLen(EncType encType) {
        if (encType == EncType.DES) {
            return 56;
        }
        if (encType == EncType.DESede) {
            return 168;
        }
        if (encType == EncType.AES) {
            return 128;
        }
        return 0;
    }
}

