/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import cn.jants.common.bean.JsonMap;
import cn.jants.common.utils.IOUtil;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MapXmlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MapXmlUtil.class);

    public static String map2Xml(TreeMap map, String tagName) {
        StringBuffer sb = new StringBuffer("");
        sb.append("<" + tagName + ">");
        Set entries = map.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            sb.append("<").append(key).append(">");
            if (value instanceof String) {
                sb.append("<![CDATA[").append(value).append("]]>");
            } else {
                sb.append(value);
            }
            sb.append("</").append(key).append(">");
        }
        sb.append("</" + tagName + ">");
        return sb.toString();
    }

    public static Map xml2Map(String strXml, String tagName) {
        JsonMap map = JsonMap.newJsonMap();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document doc = documentBuilder.parse(IOUtil.parseInputStream(strXml));
            NodeList list = doc.getElementsByTagName(tagName);
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                NodeList childNodes = node.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node childNode = childNodes.item(j);
                    if (childNode.getNodeType() != 1) continue;
                    map.put(childNode.getNodeName(), childNode.getTextContent());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error("xml to map is error > " + e.getMessage());
        }
        return map;
    }
}

