/*
 * Decompiled with CFR 0.152.
 */
package cn.jants.common.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtil.class);

    public static String sendGet(String path, Map<String, String> headers, String charset) {
        try {
            URL url = new URL(path.trim());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("GET");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (urlConnection.getResponseCode() == 200) {
                urlConnection.connect();
                InputStream is = urlConnection.getInputStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                int len = 0;
                while (-1 != (len = is.read(buffer))) {
                    byteArrayOutputStream.write(buffer, 0, len);
                    byteArrayOutputStream.flush();
                }
                return byteArrayOutputStream.toString(charset == null ? "utf-8" : charset);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
        }
        return null;
    }

    public static String sendGet(String path) {
        return HttpUtil.sendGet(path, null, null);
    }

    public static String sendGet(String path, Map<String, String> headers) {
        return HttpUtil.sendGet(path, headers, null);
    }

    public static String sendPost(String path, String body, Map<String, String> params, Map<String, String> headers, String charset) {
        URL url = null;
        try {
            url = new URL(path);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            httpURLConnection.connect();
            PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
            if (params != null) {
                StringBuffer postParams = new StringBuffer();
                int i = 0;
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    postParams.append(entry.getKey() + "=" + entry.getValue());
                    if (i != params.size() - 1) {
                        postParams.append("&");
                    }
                    ++i;
                }
                printWriter.write(postParams.toString());
            }
            if (body != null) {
                printWriter.write(body);
            }
            printWriter.flush();
            if (httpURLConnection.getResponseCode() == 200) {
                int len;
                BufferedInputStream bis = new BufferedInputStream(httpURLConnection.getInputStream());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                byte[] arr = new byte[1024];
                while ((len = bis.read(arr)) != -1) {
                    bos.write(arr, 0, len);
                    bos.flush();
                }
                bos.close();
                return bos.toString(charset == null ? "utf-8" : charset);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOG.error(e.getMessage());
        }
        return null;
    }

    public static String sendPost(String path, Map<String, String> params, Map<String, String> headers) {
        return HttpUtil.sendPost(path, null, params, headers, null);
    }

    public static String sendPost(String path, Map<String, String> params) {
        return HttpUtil.sendPost(path, null, params, null, null);
    }

    public static String sendPost(String path, String body, Map<String, String> headers) {
        return HttpUtil.sendPost(path, body, null, headers, null);
    }

    public static String sendPost(String path, String body) {
        return HttpUtil.sendPost(path, body, null, null, null);
    }
}

