/*
 * Decompiled with CFR 0.152.
 */
package cn.izern.spring.boot.autoconfigure.fastjson;

import cn.izern.spring.boot.autoconfigure.fastjson.FastjsonProperties;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.web.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;

@Configuration
@ConditionalOnClass(value={FastJsonHttpMessageConverter.class})
@EnableConfigurationProperties(value={FastjsonProperties.class})
public class FastjsonAutoConfiguration {
    @Autowired
    private FastjsonProperties properties;

    @Bean
    public HttpMessageConverters fastJsonHttpMessageConverters() {
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setSerializerFeatures(this.properties.getSerializerFeatures());
        fastJsonConfig.setDateFormat(this.properties.getDateFormat());
        fastJsonConfig.setFeatures(this.properties.getFeature());
        fastConverter.setFastJsonConfig(fastJsonConfig);
        FastJsonHttpMessageConverter converter = fastConverter;
        return new HttpMessageConverters(new HttpMessageConverter[]{converter});
    }
}

