/*
 * Decompiled with CFR 0.152.
 */
package cn.izern.spring.boot.autoconfigure.druid;

import cn.izern.spring.boot.autoconfigure.druid.DruidProperties;
import cn.izern.spring.boot.autoconfigure.druid.DruidSpringAopConfiguration;
import cn.izern.spring.boot.autoconfigure.druid.DruidStatFilterConfiguration;
import cn.izern.spring.boot.autoconfigure.druid.DruidStatViewServletConfiguration;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={DruidDataSource.class})
@EnableConfigurationProperties(value={DruidProperties.class})
@Import(value={DruidSpringAopConfiguration.class, DruidStatViewServletConfiguration.class, DruidStatFilterConfiguration.class})
public class DruidDataSourcePropertiesAutoConfigure {
    @Bean
    @ConfigurationProperties(value="spring.datasource")
    public DataSource dataSource(DruidProperties properties) {
        DruidDataSource datasource = (DruidDataSource)DataSourceBuilder.create().type(DruidDataSource.class).build();
        this.configDruid(datasource, properties);
        return datasource;
    }

    private void configDruid(DruidDataSource datasource, DruidProperties properties) {
        if (properties.getMaxActive() != null) {
            datasource.setMaxActive(properties.getMaxActive().intValue());
        }
        if (properties.getInitialSize() != null) {
            datasource.setInitialSize(properties.getInitialSize().intValue());
        }
        if (properties.getMaxWait() != null) {
            datasource.setMaxWait((long)properties.getMaxWait().intValue());
        }
        if (properties.getMinIdle() != null) {
            datasource.setMinIdle(properties.getMinIdle().intValue());
        }
        if (properties.getTimeBetweenEvictionRunsMillis() != null) {
            datasource.setTimeBetweenEvictionRunsMillis((long)properties.getTimeBetweenEvictionRunsMillis().intValue());
        }
        if (properties.getMinEvictableIdleTimeMillis() != null) {
            datasource.setMinEvictableIdleTimeMillis((long)properties.getMinEvictableIdleTimeMillis().intValue());
        }
        if (properties.getTestWhileIdle() != null) {
            datasource.setTestWhileIdle(properties.getTestWhileIdle().booleanValue());
        }
        if (properties.getTestOnBorrow() != null) {
            datasource.setTestOnBorrow(properties.getTestOnBorrow().booleanValue());
        }
        if (properties.getTestOnReturn() != null) {
            datasource.setTestOnReturn(properties.getTestOnReturn().booleanValue());
        }
        if (properties.getPoolPreparedStatements() != null) {
            datasource.setPoolPreparedStatements(properties.getPoolPreparedStatements().booleanValue());
        }
        if (properties.getMaxPoolPreparedStatementPerConnectionSize() != null) {
            datasource.setMaxPoolPreparedStatementPerConnectionSize(properties.getMaxPoolPreparedStatementPerConnectionSize().intValue());
        }
        try {
            datasource.setFilters(properties.getFilters() != null ? properties.getFilters() : "stat");
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("please check your spring.datasource.druid.filters property.", e);
        }
    }
}

