/*
 * Decompiled with CFR 0.152.
 */
package cn.izern.commons.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.conn.util.PublicSuffixMatcherLoader;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientUtils {
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(30000).setConnectTimeout(30000).setConnectionRequestTimeout(30000).build();

    public static String sendHttpPost(String httpUrl) {
        HttpPost httpPost = new HttpPost(httpUrl);
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, String params) {
        HttpPost httpPost = new HttpPost(httpUrl);
        try {
            StringEntity stringEntity = new StringEntity(params, "UTF-8");
            httpPost.setEntity((HttpEntity)stringEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    public static String sendHttpPost(String httpUrl, Map<String, String> maps) {
        HttpPost httpPost = new HttpPost(httpUrl);
        ArrayList<BasicNameValuePair> nameValuePairs = new ArrayList<BasicNameValuePair>();
        for (String key : maps.keySet()) {
            nameValuePairs.add(new BasicNameValuePair(key, maps.get(key)));
        }
        try {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValuePairs, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return HttpClientUtils.sendHttpPost(httpPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpPost(HttpPost httpPost) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpPost.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpPost);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    public static String sendHttpGet(String httpUrl) {
        HttpGet httpGet = new HttpGet(httpUrl);
        return HttpClientUtils.sendHttpGet(httpGet);
    }

    public static String sendHttpGet(String httpUrl, Map<String, String> header) {
        HttpGet httpGet = new HttpGet(httpUrl);
        Set<String> keys = header.keySet();
        for (String key : keys) {
            httpGet.setHeader(key, header.get(key));
        }
        return HttpClientUtils.sendHttpGet(httpGet);
    }

    public static String sendHttpsGet(String httpUrl) {
        HttpGet httpGet = new HttpGet(httpUrl);
        return HttpClientUtils.sendHttpsGet(httpGet);
    }

    public static String sendHttpsGet(String httpUrl, Map<String, String> header) {
        HttpGet httpGet = new HttpGet(httpUrl);
        Set<String> keys = header.keySet();
        for (String key : keys) {
            httpGet.setHeader(key, header.get(key));
        }
        return HttpClientUtils.sendHttpsGet(httpGet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpGet(HttpGet httpGet) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            httpClient = HttpClients.createDefault();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String sendHttpsGet(HttpGet httpGet) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        String responseContent = null;
        try {
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load((URL)new URL(httpGet.getURI().toString()));
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier(publicSuffixMatcher);
            httpClient = HttpClients.custom().setSSLHostnameVerifier((HostnameVerifier)hostnameVerifier).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            entity = response.getEntity();
            responseContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
                if (httpClient != null) {
                    httpClient.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return responseContent;
    }
}

