/*
 * Decompiled with CFR 0.152.
 */
package cn.izern.commons.util;

import cn.izern.commons.util.PropertiesUtils;
import cn.izern.commons.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUtils {
    private String _username;
    private String _password;
    private String _url;
    private Integer _port;
    private String _enconding;
    private FTPClient client;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public FTPUtils(String _username, String _password, String _url) {
        this(_username, _password, _url, 21);
    }

    public FTPUtils(String _username, String _password, String _url, Integer _port) {
        this(_username, _password, _url, _port, "UTF-8");
    }

    public FTPUtils(String _username, String _password, String _url, Integer _port, String _enconding) {
        this._username = _username;
        this._password = _password;
        this._url = _url;
        this._port = _port;
        this._enconding = _enconding;
    }

    @Deprecated
    public FTPUtils(String configPath) {
        PropertiesUtils pro = new PropertiesUtils(configPath);
        String username = pro.getProperty("ftp.user");
        String password = pro.getProperty("ftp.password");
        String url = pro.getProperty("ftp.url");
        Integer port = pro.getInteger("ftp.port", 21);
        String encoding = pro.getProperty("ftp.encoding", "UTF-8");
        this._username = username;
        this._password = password;
        this._url = url;
        this._port = port;
        this._enconding = encoding;
    }

    private void buildClient() {
        if (this.client == null || !this.client.isConnected()) {
            FTPClient client = null;
            try {
                client = new FTPClient();
                client.connect(this._url, this._port.intValue());
                client.login(this._username, this._password);
                if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
                    this.log.info("\u672a\u8fde\u63a5\u5230FTP\uff0c\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\u3002");
                    client.disconnect();
                } else {
                    this.log.info("FTP\u8fde\u63a5\u6210\u529f\u3002");
                }
                client.setControlEncoding(this._enconding);
                client.setBufferSize(1024);
                client.setConnectTimeout(6000);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.client = client;
        }
    }

    public Boolean uploadFile(File srcFile, String remotePath) {
        return this.uploadFile(srcFile, srcFile.getName(), remotePath);
    }

    public Boolean uploadFile(File srcFile, String newFileName, String remotePath) {
        this.buildClient();
        Boolean success = false;
        try {
            FileInputStream is = new FileInputStream(srcFile);
            this.changeDiretory(remotePath);
            success = this.client.storeFile(newFileName, (InputStream)is);
            ((InputStream)is).close();
            this.log.info("upload file " + newFileName + " success");
            this.close();
        }
        catch (FileNotFoundException e) {
            this.log.info("Srcfile not found");
            e.printStackTrace();
        }
        catch (IOException e) {
            this.log.info("\u4e0a\u4f20\u5931\u8d25");
            e.printStackTrace();
        }
        return success;
    }

    public Boolean uploadFiles(List<File> files, List<String> fileNames, String remotePath) {
        if (fileNames.size() != files.size()) {
            throw new IndexOutOfBoundsException("files size must be equal to fileNames size");
        }
        this.buildClient();
        Boolean success = false;
        try {
            this.changeDiretory(remotePath);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (int i = 0; i < files.size(); ++i) {
            try {
                FileInputStream is = new FileInputStream(files.get(i));
                success = this.client.storeFile(fileNames.get(i), (InputStream)is);
                ((InputStream)is).close();
                if (!success.booleanValue()) break;
                this.log.info("upload file " + fileNames.get(i) + " success");
                continue;
            }
            catch (FileNotFoundException e) {
                this.log.info("Srcfile not found");
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                this.log.info("\u4e0a\u4f20\u5931\u8d25");
                e.printStackTrace();
            }
        }
        this.close();
        return success;
    }

    public Boolean uploadFiles(List<File> files, String remotePath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (File file : files) {
            fileNames.add(file.getName());
        }
        return this.uploadFiles(files, fileNames, remotePath);
    }

    public Boolean downloadFile(String fileName, String remotePath, File LocalFile) {
        this.buildClient();
        Boolean success = false;
        try {
            FTPFile[] files;
            this.changeDiretory(remotePath);
            for (FTPFile ftpFile : files = this.client.listFiles()) {
                if (!ftpFile.getName().equals(fileName)) continue;
                FileOutputStream os = new FileOutputStream(LocalFile);
                this.client.retrieveFile(fileName, (OutputStream)os);
                os.flush();
                ((OutputStream)os).close();
                success = true;
            }
            if (success.booleanValue()) {
                this.log.info("download file success");
            } else {
                this.log.info("could not find file");
            }
        }
        catch (IOException e) {
            this.log.info("\u4e0b\u8f7d\u5931\u8d25");
            e.printStackTrace();
        }
        return success;
    }

    public void close() {
        if (this.client != null && this.client.isConnected()) {
            try {
                this.client.logout();
                this.client.disconnect();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void changeDiretory(String path) throws IOException {
        String[] paths;
        this.buildClient();
        this.client.changeWorkingDirectory("/");
        for (String string : paths = path.split("/")) {
            if (StringUtils.isBlank((CharSequence)string) || this.client.changeWorkingDirectory(string)) continue;
            this.client.makeDirectory(string);
            this.client.changeWorkingDirectory(string);
        }
    }

    public FTPClient getClient() {
        this.buildClient();
        return this.client;
    }
}

