/*
 * Decompiled with CFR 0.152.
 */
package cn.izern.commons.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelReader {
    private static Logger log = LoggerFactory.getLogger(ExcelReader.class);
    private Workbook wb;
    private Sheet sheet;
    private int headerNum;
    private String fileName;
    private FormulaEvaluator evaluator;

    public ExcelReader(String fileName, int headerNum) throws InvalidFormatException, IOException {
        this(new File(fileName), headerNum);
    }

    public ExcelReader(File file, int headerNum) throws InvalidFormatException, IOException {
        this(file, headerNum, 0);
    }

    public ExcelReader(String fileName, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(new File(fileName), headerNum, sheetIndex);
    }

    public ExcelReader(File file, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(file.getName(), new FileInputStream(file), headerNum, sheetIndex);
        this.fileName = file.getAbsolutePath();
    }

    public ExcelReader(MultipartFile multipartFile, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        this(multipartFile.getOriginalFilename(), multipartFile.getInputStream(), headerNum, sheetIndex);
    }

    public ExcelReader(String fileName, InputStream is, int headerNum, int sheetIndex) throws InvalidFormatException, IOException {
        if (StringUtils.isBlank((CharSequence)fileName)) {
            throw new RuntimeException("\u5bfc\u5165\u6587\u6863\u4e3a\u7a7a!");
        }
        if (fileName.toLowerCase().endsWith("xls")) {
            this.wb = new HSSFWorkbook(is);
        } else if (fileName.toLowerCase().endsWith("xlsx")) {
            this.wb = new XSSFWorkbook(is);
        } else {
            throw new RuntimeException("\u6587\u6863\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        if (this.wb.getNumberOfSheets() < sheetIndex) {
            throw new RuntimeException("\u6587\u6863\u4e2d\u6ca1\u6709\u5de5\u4f5c\u8868!");
        }
        this.sheet = this.wb.getSheetAt(sheetIndex);
        this.headerNum = headerNum;
        this.evaluator = this.wb.getCreationHelper().createFormulaEvaluator();
        log.debug("Initialize success.");
    }

    public String getFileName() {
        return this.fileName;
    }

    public Workbook getWb() {
        return this.wb;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public Row getRow(int rownum) {
        return this.sheet.getRow(rownum);
    }

    public int getDataRowNum() {
        return this.headerNum + 1;
    }

    public int getLastDataRowNum() {
        return this.sheet.getLastRowNum() + this.getDataRowNum();
    }

    public int getLastCellNum() {
        return this.getRow(this.headerNum).getLastCellNum();
    }

    public int getHeaderNum() {
        return this.headerNum;
    }

    public Object getCellValue(Row row, int column) {
        Object val = "";
        try {
            Cell cell = row.getCell(column);
            if (cell != null) {
                if (cell.getCellType() == 0) {
                    val = cell.getNumericCellValue();
                } else if (cell.getCellType() == 1) {
                    val = cell.getStringCellValue();
                } else if (cell.getCellType() == 2) {
                    CellValue cellValue = this.evaluator.evaluate(cell);
                    switch (cellValue.getCellType()) {
                        case 1: {
                            val = cellValue.getStringValue();
                            break;
                        }
                        case 0: {
                            val = cellValue.getNumberValue();
                            break;
                        }
                        case 4: {
                            val = cellValue.getBooleanValue();
                            break;
                        }
                        case 5: {
                            val = cellValue.getErrorValue();
                            log.warn("read excel error {}", (Object)val.toString());
                            break;
                        }
                        case 2: {
                            val = null;
                            break;
                        }
                        default: {
                            val = null;
                            break;
                        }
                    }
                } else if (cell.getCellType() == 4) {
                    val = cell.getBooleanCellValue();
                } else if (cell.getCellType() == 5) {
                    val = cell.getErrorCellValue();
                }
            }
        }
        catch (Exception e) {
            return val;
        }
        return val;
    }

    public int getCellnumByString(String col) {
        Row head = this.getRow(this.headerNum);
        int cellnum = -1;
        for (int i = 0; i < head.getLastCellNum(); ++i) {
            String val = this.getCellValue(head, i).toString();
            if (!col.equalsIgnoreCase(val)) continue;
            cellnum = i;
            break;
        }
        return cellnum;
    }
}

