package cn.ivan95.me.enums;

/**
 * id自增列
 * @program: mybatis-extend-parent
 * @author: Ivan.Ding
 * @create: 2018-11-25 14:22
 **/
public enum  IdAutoIncrementType {

    /**
     * 默认值
     * 数据库自增，ME不做处理/insert
     */
    AUTO_INCREMENT("数据库自增，ME不做处理/insert"),

    /**
     * 使用实体中id字段的值
     */
    INPUT("使用实体中id字段的值"),

    /**
     * 创建UUID
     */
    UUID("创建UUID"),

    /**
     * 创建SnowFlakeId相比UUID，SnowFlakeId创建的为long型数据，很小的数据存储空间，性能好）
     */
    SNOWFLAKEID("创建SnowFlakeId相比UUID，SnowFlakeId创建的为long型数据，很小的数据存储空间，性能好）"),


    /**
     * 使用时间戳
     */
    TIMESTAMP("使用时间戳"),
    /**
     * selectKey ,针对oracle无id自增特性建立
     */
    SELECTKEY("electKey ,针对oracle无id自增特性建立");

    private final String desc;

    IdAutoIncrementType(String desc){
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }
}
