/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.nativeloader;

import cn.itcraft.nativeloader.LibInfo;
import cn.itcraft.nativeloader.NativeLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SimpleLibInfo
implements LibInfo {
    private static final Map<String, String> LIB_NAME_MAP = new ConcurrentHashMap<String, String>();
    private final String shortName;
    private final String prefix;
    private final String name;
    private final String inJarPath;
    private final String libFilePath;

    public SimpleLibInfo(String shortName) {
        this.shortName = shortName;
        this.prefix = "lib" + shortName;
        this.name = NativeLoader.OS_IS_WIN ? this.shortName + NativeLoader.EXT : this.prefix + NativeLoader.EXT;
        this.inJarPath = "resources/" + this.name;
        this.libFilePath = SimpleLibInfo.getPropertyByName(shortName);
    }

    private static String getPropertyByName(String name) {
        return LIB_NAME_MAP.computeIfAbsent(name, n -> System.getProperty(n + "Lib", "ENV_LIB_PARAM_NOT_EXIST"));
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String prefix() {
        return this.prefix;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String jarPath() {
        return this.inJarPath;
    }

    @Override
    public String filePath() {
        return this.libFilePath;
    }
}

