/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.nativeloader;

import cn.itcraft.nativeloader.LibInfo;
import cn.itcraft.nativeloader.NativeLoadException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLoader.class);
    static final String OS_NAME = System.getProperty("os.name");
    static final String EXT = OS_NAME.toLowerCase().contains("win") ? ".dll" : ".so";
    static final String LIB_DEF = "ENV_LIB_PARAM_NOT_EXIST";
    private static final String TMP_DIR = System.getProperty("java.io.tmpdir");

    public static void load(LibInfo libInfo) {
        String name = libInfo.name();
        if (!(NativeLoader.loadFromSysLibPath(name, libInfo.shortName()) || NativeLoader.loadFromJar(name, libInfo.jarPath(), libInfo.prefix()) || NativeLoader.loadFromSysProperties(name, libInfo.filePath()))) {
            throw new NativeLoadException("load native library[" + name + "] failed", new UnsatisfiedLinkError(name));
        }
        LOGGER.info("load native library[{}] success", (Object)name);
    }

    private static boolean loadFromSysLibPath(String name, String shortName) {
        LOGGER.debug("try load native library[{}] from sys lib path", (Object)name);
        try {
            System.loadLibrary(shortName);
            return true;
        }
        catch (UnsatisfiedLinkError error) {
            LOGGER.warn("try load lib[{}] from sys lib path failed: {}", (Object)name, (Object)error.getMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadFromJar(String name, String jarPath, String prefix) {
        LOGGER.debug("try load native library[{}] from classpath", (Object)jarPath);
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(jarPath);){
            if (is == null) {
                LOGGER.warn("try load lib[{}] in jar failed, {} is not found in classpath", (Object)name, (Object)jarPath);
                boolean bl2 = false;
                return bl2;
            }
            Path tmpDir = Paths.get(TMP_DIR, new String[0]);
            Path tmpLib = Files.createTempFile(tmpDir, prefix, EXT, new FileAttribute[0]);
            tmpLib.toFile().deleteOnExit();
            Files.copy(is, tmpLib, StandardCopyOption.REPLACE_EXISTING);
            System.load(tmpLib.toAbsolutePath().toString());
            boolean bl = true;
            return bl;
        }
        catch (IOException | UnsatisfiedLinkError thrown) {
            LOGGER.warn("failed to load native library[{}] from classpath: {}", (Object)jarPath, (Object)thrown.getMessage());
            return false;
        }
    }

    private static boolean loadFromSysProperties(String name, String filePath) {
        if (LIB_DEF.equals(filePath)) {
            LOGGER.debug("skip loading native library[{}] from env", (Object)name);
            return false;
        }
        LOGGER.debug("try load native library[{}] from {}", (Object)name, (Object)filePath);
        try {
            System.load(filePath);
            return true;
        }
        catch (UnsatisfiedLinkError error) {
            LOGGER.warn("failed to load native library[{}] from {}: {}", new Object[]{name, filePath, error.getMessage()});
            return false;
        }
    }
}

