/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.frogspawn.util;

import cn.itcraft.frogspawn.util.UnsafeUtil;
import java.lang.reflect.Array;
import sun.misc.Unsafe;

public final class ArrayUtil {
    public static final int BUFFER_PAD;
    public static final long REF_ARRAY_BASE;
    public static final int REF_ELEMENT_SHIFT;
    private static final Unsafe UNSAFE;

    private ArrayUtil() {
    }

    public static <T> T[] createArray(Class<T> clazz, int capacity) {
        return (Object[])Array.newInstance(clazz, capacity + 2 * BUFFER_PAD);
    }

    private static long locateInArray(long sequence, int mask) {
        return REF_ARRAY_BASE + ((sequence & (long)mask) << REF_ELEMENT_SHIFT);
    }

    public static <T> T elementAt(T[] array, int mask, long sequence) {
        return (T)UNSAFE.getObject(array, ArrayUtil.locateInArray(sequence, mask));
    }

    public static <T> void fillElementAt(T[] array, int mask, long sequence, T t) {
        UNSAFE.putObject(array, ArrayUtil.locateInArray(sequence, mask), t);
    }

    public static int findNextPositivePowerOfTwo(int value) {
        if (value < 0) {
            throw new RuntimeException("must be positive");
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    static {
        UNSAFE = UnsafeUtil.getUnsafe();
        int scale = UNSAFE.arrayIndexScale(Object[].class);
        if (4 == scale) {
            REF_ELEMENT_SHIFT = 2;
        } else if (8 == scale) {
            REF_ELEMENT_SHIFT = 3;
        } else {
            throw new IllegalStateException("Unknown pointer size");
        }
        BUFFER_PAD = 128 / scale;
        REF_ARRAY_BASE = UNSAFE.arrayBaseOffset(Object[].class) + (BUFFER_PAD << REF_ELEMENT_SHIFT);
    }
}

