/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.frogspawn.misc;

import cn.itcraft.frogspawn.Resettable;
import cn.itcraft.frogspawn.constants.Constants;
import cn.itcraft.frogspawn.util.ArrayUtil;
import java.lang.ref.SoftReference;

public class SoftRefStore<T extends Resettable> {
    private static final int INITIAL_CAPACITY = Constants.CACHE_CAPACITY;
    private static final int MASK = INITIAL_CAPACITY - 1;
    private final SoftReference<Object[]> softRef = new SoftReference<Object[]>(ArrayUtil.createArray(Object.class, INITIAL_CAPACITY));
    private int size = 0;
    private long fetchWalker = 0L;
    private long releaseWalker = 0L;

    public T fetch() {
        if (this.size == 0) {
            return null;
        }
        Object[] array = this.softRef.get();
        return array == null ? null : (T)this.getFromArray(array);
    }

    private T getFromArray(Object[] array) {
        for (int i = 0; i < INITIAL_CAPACITY; ++i) {
            T t = this.fetchArrayElement(array, i);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    private T fetchArrayElement(Object[] array, int idx) {
        long newVal = this.fetchWalker + (long)idx + 1L;
        Resettable obj = (Resettable)ArrayUtil.elementAt(array, MASK, newVal);
        if (obj == null) {
            return null;
        }
        ArrayUtil.fillElementAt(array, MASK, newVal, null);
        this.fetchWalker = newVal;
        --this.size;
        return (T)obj;
    }

    public boolean release(T obj) {
        if (obj == null || this.size == INITIAL_CAPACITY) {
            return true;
        }
        Object[] array = this.softRef.get();
        return array == null || this.putToArray(array, obj);
    }

    private boolean putToArray(Object[] array, T obj) {
        for (int i = 0; i < INITIAL_CAPACITY; ++i) {
            if (!this.restoreArrayElement(array, obj, i)) continue;
            return false;
        }
        return true;
    }

    private boolean restoreArrayElement(Object[] array, T obj, int idx) {
        long newVal = this.releaseWalker + (long)idx + 1L;
        Resettable x = (Resettable)ArrayUtil.elementAt(array, MASK, newVal);
        if (x == null) {
            ArrayUtil.fillElementAt(array, MASK, newVal, obj);
            this.releaseWalker = newVal;
            ++this.size;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }
}

