/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.frogspawn.impl;

import cn.itcraft.frogspawn.ObjectCreator;
import cn.itcraft.frogspawn.ObjectsMemoryPool;
import cn.itcraft.frogspawn.Resettable;
import cn.itcraft.frogspawn.constants.Constants;
import cn.itcraft.frogspawn.data.WrappedResettable;
import cn.itcraft.frogspawn.impl.FetchHelper;
import cn.itcraft.frogspawn.impl.Fetcher;
import cn.itcraft.frogspawn.impl.Releaser;
import cn.itcraft.frogspawn.misc.PaddedAtomicLong;
import cn.itcraft.frogspawn.misc.SoftRefStore;
import cn.itcraft.frogspawn.strategy.FetchFailStrategy;
import cn.itcraft.frogspawn.strategy.FetchStrategy;
import cn.itcraft.frogspawn.strategy.PoolStrategy;
import cn.itcraft.frogspawn.util.ArrayUtil;

public class ObjectsMemoryPoolImpl<T extends Resettable>
implements ObjectsMemoryPool<T> {
    protected static final ThreadLocal<SoftRefStore<Resettable>> LOCAL_QUEUE = ThreadLocal.withInitial(SoftRefStore::new);
    protected final PaddedAtomicLong walker = new PaddedAtomicLong(0L);
    protected final WrappedResettable[] array;
    protected final int indexMask;
    private final ObjectCreator<T> creator;
    private final FetchFailStrategy fetchFailStrategy;
    private final Fetcher<T> fetcher;
    private final Fetcher<T> fetcherActual;
    private final Releaser<T> releaser;

    public ObjectsMemoryPoolImpl(ObjectCreator<T> creator, int size, PoolStrategy poolStrategy) {
        int calculatedCapacity = ArrayUtil.findNextPositivePowerOfTwo(size);
        int capacity = Math.min(calculatedCapacity, Constants.MAX_CAPACITY);
        this.indexMask = capacity - 1;
        this.array = ArrayUtil.createArray(WrappedResettable.class, capacity);
        int paddedCapacity = ArrayUtil.BUFFER_PAD + capacity;
        for (int i = ArrayUtil.BUFFER_PAD; i < paddedCapacity; ++i) {
            WrappedResettable<T> wrapped = new WrappedResettable<T>(creator.create());
            wrapped.getObj().markId(i);
            this.array[i] = wrapped;
        }
        this.creator = creator;
        if (poolStrategy.isPrefetch()) {
            this.fetcher = this::fetchWithPrefetch;
            this.releaser = this::releaseDirect;
        } else {
            this.fetcher = this::fetchWithCache;
            this.releaser = this::releaseLocalFirst;
        }
        if (FetchStrategy.MUST_FETCH_IN_POOL.equals((Object)poolStrategy.getFetchStrategy())) {
            this.fetchFailStrategy = null;
            this.fetcherActual = this::fetchDataWithLoop;
        } else {
            this.fetchFailStrategy = poolStrategy.getFetchFailStrategy();
            this.fetcherActual = this::fetchDataWithTimes;
        }
    }

    @Override
    public T fetch() {
        return (T)((Resettable)this.fetcher.fetch());
    }

    private T fetchWithCache() {
        Resettable t = LOCAL_QUEUE.get().fetch();
        if (t == null || t.isInvalid()) {
            return this.fetchDataWithTimes();
        }
        return (T)t;
    }

    private T fetchWithPrefetch() {
        SoftRefStore<Resettable> softRefStore = LOCAL_QUEUE.get();
        Resettable t = softRefStore.fetch();
        if (t == null || t.isInvalid()) {
            t = (Resettable)this.fetcherActual.fetch();
            this.prefetch(softRefStore);
        }
        return (T)t;
    }

    protected T fetchDataWithTimes() {
        return FetchHelper.fetchDataOrFailover(this.array, this.indexMask, this.walker, this.fetchFailStrategy, this.creator);
    }

    protected T fetchDataWithLoop() {
        return FetchHelper.loopFetchData(this.array, this.indexMask, this.walker);
    }

    private void prefetch(SoftRefStore<Resettable> softRefStore) {
        if (softRefStore.isEmpty()) {
            Resettable t;
            for (int i = 0; i < Constants.CACHE_CAPACITY && (t = (Resettable)this.fetcherActual.fetch()) != null; ++i) {
                softRefStore.release(t);
            }
        }
    }

    @Override
    public void release(T used) {
        this.releaser.release(used);
    }

    private void releaseLocalFirst(T used) {
        if (LOCAL_QUEUE.get().release((Resettable)used)) {
            this.wrapRelease(used);
        }
    }

    private void releaseDirect(T used) {
        this.wrapRelease(used);
    }

    protected void wrapRelease(T used) {
        used.reset();
        int id = used.getMarkedId();
        if (id >= 0) {
            this.array[id].getUsed().compareAndSet(true, false);
        }
    }
}

