/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.frogspawn.impl;

import cn.itcraft.frogspawn.ObjectCreator;
import cn.itcraft.frogspawn.Resettable;
import cn.itcraft.frogspawn.constants.Constants;
import cn.itcraft.frogspawn.data.WrappedResettable;
import cn.itcraft.frogspawn.strategy.FetchFailStrategy;
import cn.itcraft.frogspawn.util.ArrayUtil;
import java.util.concurrent.atomic.AtomicLong;

final class FetchHelper {
    private FetchHelper() {
    }

    public static <T extends Resettable> T fetchDataOrFailover(WrappedResettable[] array, int indexMask, AtomicLong walker, FetchFailStrategy fetchFailStrategy, ObjectCreator<T> creator) {
        for (int i = 0; i < Constants.FETCH_TIMES; ++i) {
            WrappedResettable wrapped = ArrayUtil.elementAt(array, indexMask, walker.getAndIncrement());
            if (!FetchHelper.matchedUnused(wrapped)) continue;
            return FetchHelper.fetchFromWrapped(wrapped);
        }
        return fetchFailStrategy.failover(creator);
    }

    public static <T extends Resettable> T loopFetchData(WrappedResettable[] array, int indexMask, AtomicLong walker) {
        WrappedResettable wrapped;
        while (!FetchHelper.matchedUnused(wrapped = ArrayUtil.elementAt(array, indexMask, walker.getAndIncrement()))) {
        }
        return FetchHelper.fetchFromWrapped(wrapped);
    }

    private static <T extends Resettable> boolean matchedUnused(WrappedResettable<T> wrapped) {
        return wrapped.getUsed().compareAndSet(false, true);
    }

    private static <T extends Resettable> T fetchFromWrapped(WrappedResettable<T> wrapped) {
        return wrapped.getObj();
    }
}

