/*
 * Decompiled with CFR 0.152.
 */
package cn.itcraft.frogspawn;

import cn.itcraft.frogspawn.ObjectCreator;
import cn.itcraft.frogspawn.ObjectsMemoryPool;
import cn.itcraft.frogspawn.Resettable;
import cn.itcraft.frogspawn.impl.ObjectsMemoryPoolImpl;
import cn.itcraft.frogspawn.strategy.FetchFailStrategy;
import cn.itcraft.frogspawn.strategy.FetchStrategy;
import cn.itcraft.frogspawn.strategy.PoolStrategy;

public final class ObjectsMemoryPoolFactory {
    private ObjectsMemoryPoolFactory() {
    }

    public static <T extends Resettable> ObjectsMemoryPool<T> newPool(ObjectCreator<T> creator, int size) {
        return ObjectsMemoryPoolFactory.newPool(creator, size, new PoolStrategy(FetchStrategy.FETCH_FAIL_AS_NEW, FetchFailStrategy.CALL_CREATOR, false));
    }

    public static <T extends Resettable> ObjectsMemoryPool<T> newPool(ObjectCreator<T> creator, int size, PoolStrategy poolStrategy) {
        if (poolStrategy == null) {
            throw new IllegalArgumentException("Pool strategy can not be null");
        }
        return new ObjectsMemoryPoolImpl<T>(creator, size, poolStrategy);
    }
}

