package cn.istr.lutool;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

@Setter
@Getter
public class CommonResult<T> {

    /**
     * 逻辑结果
     */
    @Schema(title = "逻辑结果")
    private Boolean result;

    /**
     * 错误码
     */
    @Schema(title = "错误码")
    private long code;

    /**
     * 错误信息
     */
    @Schema(title = "错误信息")
    private String message;

    /**
     * 数据封装
     */
    @Schema(title = "数据")
    private T data;


    protected CommonResult() {
    }

    protected CommonResult(long code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
        this.result = code == 0;
    }

    public static <T> CommonResult<T> success() {
        return success(null);
    }

    /**
     * 成功返回结果
     *
     * @param data 获取的数据
     */
    public static <T> CommonResult<T> success(T data) {
        return new CommonResult<T>(0, "", data);
    }

    /**
     * 成功返回结果
     *
     * @param data    获取的数据
     * @param message 提示信息
     */
    public static <T> CommonResult<T> success(T data, String message) {
        return new CommonResult<T>(0, message, data);
    }

    /**
     * 失败返回结果
     */
    public static <T> CommonResult<T> failed() {
        return failed("操作失败");
    }

    /**
     * 失败返回结果
     *
     * @param errorCode 错误码
     */
    public static <T> CommonResult<T> failed(long errorCode) {
        return new CommonResult<T>(errorCode, "", null);
    }

    /**
     * 失败返回结果
     *
     * @param message 提示信息
     */
    public static <T> CommonResult<T> failed(String message) {
        return new CommonResult<T>(1, message, null);
    }

    /**
     * 失败返回结果
     *
     * @param errorCode 错误码
     * @param message   错误信息
     */
    public static <T> CommonResult<T> failed(long errorCode, String message) {
        return new CommonResult<T>(errorCode, message, null);
    }

    /**
     * 失败返回结果
     *
     * @param errorCode 错误码
     */
    public static <T> CommonResult<T> failed(IErrorCode errorCode) {
        return new CommonResult<T>(errorCode.getCode(), errorCode.getMessage(), null);
    }

    /**
     * 失败返回结果
     *
     * @param errorCode 错误码
     * @param message   错误信息
     */
    public static <T> CommonResult<T> failed(IErrorCode errorCode, String message) {
        return new CommonResult<T>(errorCode.getCode(), message, null);
    }


    // /**
    //  * 参数验证失败返回结果
    //  */
    // public static <T> CommonResult<T> validateFailed() {
    //     return failed("参数验证失败");
    // }
    //
    // /**
    //  * 参数验证失败返回结果
    //  *
    //  * @param message 提示信息
    //  */
    // public static <T> CommonResult<T> validateFailed(String message) {
    //     return new CommonResult<T>(1, message, null);
    // }
    //
    // /**
    //  * 未登录返回结果
    //  */
    // public static <T> CommonResult<T> unauthorized(T data) {
    //     return new CommonResult<T>(1, "未登录", data);
    // }
    //
    // /**
    //  * 未授权返回结果
    //  */
    // public static <T> CommonResult<T> forbidden(T data) {
    //     return new CommonResult<T>(1, "未授权", data);
    // }

}
