/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.validation;

import cn.isqing.icloud.common.api.enums.ResCodeEnum;
import cn.isqing.icloud.common.utils.dto.BaseException;
import cn.isqing.icloud.common.utils.json.JsonUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidationUtil {
    private static final Validator VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();

    public static <T> void validateWithThrow(T object, Class<?> ... groups) {
        Set validateResult = VALIDATOR.validate(object, new Class[0]);
        if (validateResult.isEmpty()) {
            return;
        }
        List list = validateResult.stream().map(c -> c.getPropertyPath() + ":" + c.getMessage()).collect(Collectors.toList());
        throw new BaseException(ResCodeEnum.VALIDATE_ERROR.getCode(), JsonUtil.toJsonString(list));
    }

    public static <T> List<String> validate(T object, Class<?> ... groups) {
        Set validateResult = VALIDATOR.validate(object, new Class[0]);
        if (validateResult.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<String> list = validateResult.stream().map(c -> c.getPropertyPath() + ":" + c.getMessage()).collect(Collectors.toList());
        return list;
    }
}

