/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.time.ratelimiter;

public class TokenBucketRatelimiterDemo {
    private long putTokenRate;
    private long refreshTime;
    private long capacity;
    private long currentToken = 0L;

    boolean tokenBucketTryAcquire() {
        long currentTime = System.currentTimeMillis();
        long generateToken = (currentTime - this.refreshTime) / 1000L * this.putTokenRate;
        this.currentToken = Math.min(this.capacity, generateToken + this.currentToken);
        this.refreshTime = currentTime;
        if (this.currentToken > 0L) {
            --this.currentToken;
            return true;
        }
        return false;
    }

    public long getPutTokenRate() {
        return this.putTokenRate;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public long getCurrentToken() {
        return this.currentToken;
    }

    public void setPutTokenRate(long putTokenRate) {
        this.putTokenRate = putTokenRate;
    }

    public void setRefreshTime(long refreshTime) {
        this.refreshTime = refreshTime;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public void setCurrentToken(long currentToken) {
        this.currentToken = currentToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenBucketRatelimiterDemo)) {
            return false;
        }
        TokenBucketRatelimiterDemo other = (TokenBucketRatelimiterDemo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPutTokenRate() != other.getPutTokenRate()) {
            return false;
        }
        if (this.getRefreshTime() != other.getRefreshTime()) {
            return false;
        }
        if (this.getCapacity() != other.getCapacity()) {
            return false;
        }
        return this.getCurrentToken() == other.getCurrentToken();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TokenBucketRatelimiterDemo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $putTokenRate = this.getPutTokenRate();
        result = result * 59 + (int)($putTokenRate >>> 32 ^ $putTokenRate);
        long $refreshTime = this.getRefreshTime();
        result = result * 59 + (int)($refreshTime >>> 32 ^ $refreshTime);
        long $capacity = this.getCapacity();
        result = result * 59 + (int)($capacity >>> 32 ^ $capacity);
        long $currentToken = this.getCurrentToken();
        result = result * 59 + (int)($currentToken >>> 32 ^ $currentToken);
        return result;
    }

    public String toString() {
        return "TokenBucketRatelimiterDemo(putTokenRate=" + this.getPutTokenRate() + ", refreshTime=" + this.getRefreshTime() + ", capacity=" + this.getCapacity() + ", currentToken=" + this.getCurrentToken() + ")";
    }
}

