/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.time;

import cn.isqing.icloud.common.utils.constants.DateConstants;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUtil {
    private static final Logger log = LoggerFactory.getLogger(TimeUtil.class);
    public static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(DateConstants.ZONE_ID);
    public static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(DateConstants.ZONE_ID);
    public static final DateTimeFormatter simpleDateFormatter = DateTimeFormatter.ofPattern("yyyyMMdd").withZone(DateConstants.ZONE_ID);
    private static volatile LocalDateTime currentTime = null;

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception e) {
            log.info("\u7761\u7720\u5f02\u5e38:{}", (Object)e.getMessage(), (Object)e);
            e.printStackTrace();
        }
    }

    public static void setCurrentTime(LocalDateTime time) {
        currentTime = time;
    }

    public static LocalDateTime now() {
        if (currentTime == null) {
            return LocalDateTime.now();
        }
        return currentTime;
    }

    public static Date nowDate() {
        if (currentTime == null) {
            return new Date();
        }
        return Date.from(currentTime.atZone(DateConstants.ZONE_ID).toInstant());
    }
}

