/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.kit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TopologicalSort {
    public static <T> List<List<T>> sort(Map<T, ? extends Collection<T>> adj) {
        HashMap<T, Integer> inDegree = new HashMap<T, Integer>();
        for (Object node : adj.keySet()) {
            inDegree.put(node, 0);
        }
        for (Object node : adj.keySet()) {
            for (T neighbor : adj.get(node)) {
                inDegree.put(neighbor, inDegree.getOrDefault(neighbor, 0) + 1);
            }
        }
        LinkedList<Object> queue = new LinkedList<Object>();
        for (Object node : inDegree.keySet()) {
            if ((Integer)inDegree.get(node) != 0) continue;
            queue.offer(node);
        }
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        while (!queue.isEmpty()) {
            int levelSize = queue.size();
            ArrayList level = new ArrayList();
            for (int i = 0; i < levelSize; ++i) {
                Object node = queue.poll();
                level.add(node);
                if (adj.get(node) == null) continue;
                for (T neighbor : adj.get(node)) {
                    inDegree.put(neighbor, (Integer)inDegree.get(neighbor) - 1);
                    if ((Integer)inDegree.get(neighbor) != 0) continue;
                    queue.offer(neighbor);
                }
            }
            result.add(level);
        }
        return result;
    }
}

