/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.kit;

import cn.isqing.icloud.common.utils.kit.Digraph;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.Set;

public class DigraphRingChecker<T> {
    private Map<T, Set<T>> adj;
    private Map<T, Boolean> searched;
    private Set<T> cycles;
    private boolean hasCycle = false;
    private Deque<T> deque = new ArrayDeque<T>();

    public DigraphRingChecker(Digraph digraph) {
        this.adj = digraph.getAdj();
    }

    public boolean hasCycle() {
        this.adj.forEach((k, v) -> {
            if (this.searched.get(k) == null) {
                this.dfs(k);
            }
        });
        return this.hasCycle;
    }

    private void dfs(T t) {
        this.searched.put(t, Boolean.TRUE);
        this.deque.push(t);
        Set<Object> set = this.adj.getOrDefault(t, Collections.emptySet());
        set.forEach(v -> {
            if (this.deque.contains(v)) {
                this.cycles.add(v);
                this.hasCycle = true;
                return;
            }
            if (this.searched.get(v) == null) {
                this.dfs(v);
            }
        });
        this.deque.pop();
    }
}

