/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.kit;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Digraph<T> {
    private Map<T, Set<T>> adj = new HashMap<T, Set<T>>();

    public void addEdge(T vertexLeft, T vertexRight) {
        Set<T> set = this.getSet(vertexLeft);
        if (vertexRight != null) {
            set.add(vertexRight);
        }
    }

    public Set<T> getSet(T vertex) {
        return this.adj.computeIfAbsent(vertex, l -> new HashSet());
    }

    public void reverse() {
        Map<T, Set<T>> adj = this.adj;
        this.adj = new HashMap<T, Set<T>>();
        adj.forEach((left, set) -> {
            if (set.isEmpty()) {
                this.addEdge(left, null);
            }
            set.forEach(right -> this.addEdge(right, left));
        });
    }

    public Map<T, Set<T>> getAdj() {
        return this.adj;
    }

    public void setAdj(Map<T, Set<T>> adj) {
        this.adj = adj;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Digraph)) {
            return false;
        }
        Digraph other = (Digraph)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<T, Set<T>> this$adj = this.getAdj();
        Map<T, Set<T>> other$adj = other.getAdj();
        return !(this$adj == null ? other$adj != null : !((Object)this$adj).equals(other$adj));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Digraph;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<T, Set<T>> $adj = this.getAdj();
        result = result * 59 + ($adj == null ? 43 : ((Object)$adj).hashCode());
        return result;
    }

    public String toString() {
        return "Digraph(adj=" + this.getAdj() + ")";
    }
}

