/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.json;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.LRUCache;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static int capacity = 300;
    private static final LRUCache<String, JSONPath> CACHE = CacheUtil.newLRUCache((int)capacity);

    public static String toJsonString(Object object) {
        try {
            return JSON.toJSONString((Object)object);
        }
        catch (Exception e) {
            log.warn("\u5bf9\u8c61\u8f6cjson\u5f02\u5e38:{},{}", (Object)e.getMessage(), object);
            return "";
        }
    }

    public static Object extract(String json, String path) {
        JSONPath jsonPath = (JSONPath)CACHE.get((Object)path);
        if (jsonPath == null) {
            jsonPath = JSONPath.of((String)path);
            CACHE.put((Object)path, (Object)jsonPath);
        }
        JSONReader jsonReader = JSONReader.of((String)json);
        return jsonPath.extract(jsonReader);
    }
}

