/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.dao;

import java.util.List;
import java.util.function.BiConsumer;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisUtils {
    private static final Logger log = LoggerFactory.getLogger(MybatisUtils.class);
    private static final int BATCH_SIZE = 100;

    public static <T, M> void batchSave(SqlSessionFactory sqlSessionFactory, List<T> list, Class<M> mapperClass, BiConsumer<T, M> consumer) {
        try (SqlSession batchSqlSession = sqlSessionFactory.openSession(ExecutorType.BATCH);){
            Object mapper = batchSqlSession.getMapper(mapperClass);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                consumer.accept(list.get(i), mapper);
                if (i % 100 != 0 && i != size - 1) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.commit(true);
        }
    }
}

