/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.dao;

import cn.isqing.icloud.common.api.enums.ResCodeEnum;
import cn.isqing.icloud.common.utils.dao.SQL;
import cn.isqing.icloud.common.utils.dto.BaseCondition;
import cn.isqing.icloud.common.utils.dto.BaseException;
import cn.isqing.icloud.common.utils.sql.SqlUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionParser {
    private static final Logger log = LoggerFactory.getLogger(ConditionParser.class);
    private static final String ERR_MSG = "\u89e3\u6790sql\u5f02\u5e38";
    private SQL sql;
    private Object object;
    private Object currentObject;
    private String tableAlias = "";
    private String tableAliasPre = "";
    private String nomalTpl = "%s`%s`=#{%s%s}";
    private String inTpl = "%s`%s` in %s";
    private final Map<String, String> specialTplMap = new HashMap<String, String>();
    private final Map<String, Consumer<Object>> baseConditionConsumerMap;
    private List<Object> list;
    private Field currentField;
    private Object currentValue;
    private String paramName;
    private String paramNamePre;
    private boolean isCount;

    public void setTableAlias(String tableAlias) {
        if (StringUtils.isEmpty((CharSequence)tableAlias)) {
            return;
        }
        this.tableAlias = tableAlias;
        this.tableAliasPre = tableAlias + ".";
    }

    public void setParamName(String paramName) {
        if (StringUtils.isEmpty((CharSequence)paramName)) {
            return;
        }
        this.paramName = paramName;
        this.paramNamePre = paramName + ".";
    }

    public void dealFiled() {
        boolean b;
        Object v = this.getV();
        if (v == null) {
            return;
        }
        if (v instanceof List && ((List)v).isEmpty()) {
            return;
        }
        String fieldName = this.currentField.getName();
        String[] arr = SqlUtil.getFieldName(fieldName, true);
        if (StringUtils.isEmpty((CharSequence)arr[0])) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)arr[1]) && (b = this.dealSpecialSymbolString(arr, fieldName, v))) {
            return;
        }
        if (v instanceof List) {
            this.dealList(arr[0]);
            return;
        }
        this.dealString(arr[0], fieldName);
    }

    private boolean dealSpecialSymbolString(String[] arr, String fieldName, Object v) {
        String s = this.specialTplMap.get(arr[1]);
        if (s == null) {
            return false;
        }
        if (v instanceof List) {
            this.list.add(String.format(this.specialTplMap.get(arr[1]), this.tableAliasPre, arr[0], this.getSqlIn()));
        } else {
            this.list.add(String.format(this.specialTplMap.get(arr[1]), this.tableAliasPre, arr[0], this.paramNamePre, fieldName));
        }
        return true;
    }

    private void dealString(String column, String fieldName) {
        this.list.add(String.format(this.nomalTpl, this.tableAliasPre, column, this.paramNamePre, fieldName));
    }

    private void dealList(String column) {
        this.list.add(String.format(this.inTpl, this.tableAliasPre, column, this.getSqlIn()));
    }

    private String getSqlIn() {
        List value1 = (List)this.currentValue;
        if (value1.isEmpty()) {
            return "()";
        }
        Object o = value1.get(0);
        if (o instanceof Long) {
            return SqlUtil.getLongSqlIn(value1);
        }
        if (o instanceof Integer) {
            return SqlUtil.getIntegerSqlIn(value1);
        }
        return SqlUtil.getSqlIn(value1);
    }

    public void dealBaseCondition() {
        String name;
        Object v = this.getV();
        if (v == null) {
            return;
        }
        switch (name = this.currentField.getName()) {
            case "limit": {
                this.setLimit();
                break;
            }
            case "offset": {
                this.setOffset();
                break;
            }
            default: {
                this.comsumer(name);
            }
        }
    }

    private void comsumer(String name) {
        Consumer<Object> consumer = this.baseConditionConsumerMap.get(name);
        if (consumer == null) {
            return;
        }
        if (this.currentValue instanceof String) {
            String value = (String)this.currentValue;
            if (!this.tableAliasPre.equals("")) {
                if (value.indexOf(",") > -1) {
                    value.replace(",", this.tableAlias + ",");
                }
                value = this.tableAliasPre + value;
            }
            consumer.accept(new String[]{value});
            return;
        }
        if (this.currentValue instanceof String[]) {
            String[] arr = (String[])this.currentValue;
            if (!this.tableAliasPre.equals("")) {
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = this.tableAliasPre + arr[i];
                }
            }
            consumer.accept(arr);
            return;
        }
        if (this.currentValue instanceof List) {
            List<String> list1 = (List<String>)this.currentValue;
            list1 = list1.stream().map(s -> this.tableAliasPre + s).collect(Collectors.toList());
            consumer.accept(list1.toArray(new String[list1.size()]));
            return;
        }
    }

    private void setOffset() {
        this.sql.OFFSET((Long)this.currentValue);
    }

    private void setLimit() {
        this.sql.LIMIT((Integer)this.currentValue);
    }

    private Object getV() {
        Object v;
        try {
            this.currentField.setAccessible(true);
            this.currentValue = v = this.currentField.get(this.currentObject);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException(ResCodeEnum.SYSTEM_ERROR.getCode(), ERR_MSG);
        }
        return v;
    }

    public void parse() {
        int n;
        Class<?> superclass;
        if (!this.isCount && (superclass = this.object.getClass().getSuperclass()).equals(BaseCondition.class)) {
            Field[] fields1 = superclass.getDeclaredFields();
            this.currentObject = this.object;
            Field[] fieldArray = fields1;
            n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field;
                this.currentField = field = fieldArray[i];
                this.dealBaseCondition();
            }
        }
        Field[] fields = this.object.getClass().getDeclaredFields();
        this.currentObject = this.object;
        Field[] fieldArray = fields;
        int n2 = fieldArray.length;
        for (n = 0; n < n2; ++n) {
            Field field;
            this.currentField = field = fieldArray[n];
            this.dealFiled();
        }
    }

    public ConditionParser() {
        this.specialTplMap.put("_min", "%s`%s`>=#{%s%s}");
        this.specialTplMap.put("_min_open", "%s`%s`>#{%s%s}");
        this.specialTplMap.put("_max", "%s`%s`<=#{%s%s}");
        this.specialTplMap.put("_max_open", "%s`%s`<#{%s%s}");
        this.specialTplMap.put("_like", "%s`%s` like #{%s%s%}");
        this.specialTplMap.put("_not_eq", "%s`%s` != #{%s%s}");
        this.specialTplMap.put("_not_in", "%s`%s` not in %s");
        this.baseConditionConsumerMap = new HashMap<String, Consumer<Object>>();
        this.baseConditionConsumerMap.put("groupBy", v -> {
            SQL cfr_ignored_0 = (SQL)this.sql.GROUP_BY((String[])v);
        });
        this.baseConditionConsumerMap.put("selectFiled", v -> {
            this.sql.REMOVE_SELECT("*");
            this.sql.SELECT((String[])v);
        });
        this.baseConditionConsumerMap.put("orderBy", v -> {
            SQL cfr_ignored_0 = (SQL)this.sql.ORDER_BY((String[])v);
        });
        this.paramName = "";
        this.paramNamePre = "";
        this.isCount = false;
    }

    public SQL getSql() {
        return this.sql;
    }

    public Object getObject() {
        return this.object;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableAliasPre() {
        return this.tableAliasPre;
    }

    public String getNomalTpl() {
        return this.nomalTpl;
    }

    public String getInTpl() {
        return this.inTpl;
    }

    public Map<String, String> getSpecialTplMap() {
        return this.specialTplMap;
    }

    public Map<String, Consumer<Object>> getBaseConditionConsumerMap() {
        return this.baseConditionConsumerMap;
    }

    public List<Object> getList() {
        return this.list;
    }

    public Field getCurrentField() {
        return this.currentField;
    }

    public Object getCurrentValue() {
        return this.currentValue;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getParamNamePre() {
        return this.paramNamePre;
    }

    public boolean isCount() {
        return this.isCount;
    }

    public void setSql(SQL sql) {
        this.sql = sql;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public void setCurrentObject(Object currentObject) {
        this.currentObject = currentObject;
    }

    public void setTableAliasPre(String tableAliasPre) {
        this.tableAliasPre = tableAliasPre;
    }

    public void setNomalTpl(String nomalTpl) {
        this.nomalTpl = nomalTpl;
    }

    public void setInTpl(String inTpl) {
        this.inTpl = inTpl;
    }

    public void setList(List<Object> list) {
        this.list = list;
    }

    public void setCurrentField(Field currentField) {
        this.currentField = currentField;
    }

    public void setCurrentValue(Object currentValue) {
        this.currentValue = currentValue;
    }

    public void setParamNamePre(String paramNamePre) {
        this.paramNamePre = paramNamePre;
    }

    public void setCount(boolean isCount) {
        this.isCount = isCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConditionParser)) {
            return false;
        }
        ConditionParser other = (ConditionParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCount() != other.isCount()) {
            return false;
        }
        SQL this$sql = this.getSql();
        SQL other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        Object this$object = this.getObject();
        Object other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Object this$currentObject = this.getCurrentObject();
        Object other$currentObject = other.getCurrentObject();
        if (this$currentObject == null ? other$currentObject != null : !this$currentObject.equals(other$currentObject)) {
            return false;
        }
        String this$tableAlias = this.getTableAlias();
        String other$tableAlias = other.getTableAlias();
        if (this$tableAlias == null ? other$tableAlias != null : !this$tableAlias.equals(other$tableAlias)) {
            return false;
        }
        String this$tableAliasPre = this.getTableAliasPre();
        String other$tableAliasPre = other.getTableAliasPre();
        if (this$tableAliasPre == null ? other$tableAliasPre != null : !this$tableAliasPre.equals(other$tableAliasPre)) {
            return false;
        }
        String this$nomalTpl = this.getNomalTpl();
        String other$nomalTpl = other.getNomalTpl();
        if (this$nomalTpl == null ? other$nomalTpl != null : !this$nomalTpl.equals(other$nomalTpl)) {
            return false;
        }
        String this$inTpl = this.getInTpl();
        String other$inTpl = other.getInTpl();
        if (this$inTpl == null ? other$inTpl != null : !this$inTpl.equals(other$inTpl)) {
            return false;
        }
        Map<String, String> this$specialTplMap = this.getSpecialTplMap();
        Map<String, String> other$specialTplMap = other.getSpecialTplMap();
        if (this$specialTplMap == null ? other$specialTplMap != null : !((Object)this$specialTplMap).equals(other$specialTplMap)) {
            return false;
        }
        Map<String, Consumer<Object>> this$baseConditionConsumerMap = this.getBaseConditionConsumerMap();
        Map<String, Consumer<Object>> other$baseConditionConsumerMap = other.getBaseConditionConsumerMap();
        if (this$baseConditionConsumerMap == null ? other$baseConditionConsumerMap != null : !((Object)this$baseConditionConsumerMap).equals(other$baseConditionConsumerMap)) {
            return false;
        }
        List<Object> this$list = this.getList();
        List<Object> other$list = other.getList();
        if (this$list == null ? other$list != null : !((Object)this$list).equals(other$list)) {
            return false;
        }
        Field this$currentField = this.getCurrentField();
        Field other$currentField = other.getCurrentField();
        if (this$currentField == null ? other$currentField != null : !((Object)this$currentField).equals(other$currentField)) {
            return false;
        }
        Object this$currentValue = this.getCurrentValue();
        Object other$currentValue = other.getCurrentValue();
        if (this$currentValue == null ? other$currentValue != null : !this$currentValue.equals(other$currentValue)) {
            return false;
        }
        String this$paramName = this.getParamName();
        String other$paramName = other.getParamName();
        if (this$paramName == null ? other$paramName != null : !this$paramName.equals(other$paramName)) {
            return false;
        }
        String this$paramNamePre = this.getParamNamePre();
        String other$paramNamePre = other.getParamNamePre();
        return !(this$paramNamePre == null ? other$paramNamePre != null : !this$paramNamePre.equals(other$paramNamePre));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConditionParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCount() ? 79 : 97);
        SQL $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        Object $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Object $currentObject = this.getCurrentObject();
        result = result * 59 + ($currentObject == null ? 43 : $currentObject.hashCode());
        String $tableAlias = this.getTableAlias();
        result = result * 59 + ($tableAlias == null ? 43 : $tableAlias.hashCode());
        String $tableAliasPre = this.getTableAliasPre();
        result = result * 59 + ($tableAliasPre == null ? 43 : $tableAliasPre.hashCode());
        String $nomalTpl = this.getNomalTpl();
        result = result * 59 + ($nomalTpl == null ? 43 : $nomalTpl.hashCode());
        String $inTpl = this.getInTpl();
        result = result * 59 + ($inTpl == null ? 43 : $inTpl.hashCode());
        Map<String, String> $specialTplMap = this.getSpecialTplMap();
        result = result * 59 + ($specialTplMap == null ? 43 : ((Object)$specialTplMap).hashCode());
        Map<String, Consumer<Object>> $baseConditionConsumerMap = this.getBaseConditionConsumerMap();
        result = result * 59 + ($baseConditionConsumerMap == null ? 43 : ((Object)$baseConditionConsumerMap).hashCode());
        List<Object> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        Field $currentField = this.getCurrentField();
        result = result * 59 + ($currentField == null ? 43 : ((Object)$currentField).hashCode());
        Object $currentValue = this.getCurrentValue();
        result = result * 59 + ($currentValue == null ? 43 : $currentValue.hashCode());
        String $paramName = this.getParamName();
        result = result * 59 + ($paramName == null ? 43 : $paramName.hashCode());
        String $paramNamePre = this.getParamNamePre();
        result = result * 59 + ($paramNamePre == null ? 43 : $paramNamePre.hashCode());
        return result;
    }

    public String toString() {
        return "ConditionParser(sql=" + this.getSql() + ", object=" + this.getObject() + ", currentObject=" + this.getCurrentObject() + ", tableAlias=" + this.getTableAlias() + ", tableAliasPre=" + this.getTableAliasPre() + ", nomalTpl=" + this.getNomalTpl() + ", inTpl=" + this.getInTpl() + ", specialTplMap=" + this.getSpecialTplMap() + ", baseConditionConsumerMap=" + this.getBaseConditionConsumerMap() + ", list=" + this.getList() + ", currentField=" + this.getCurrentField() + ", currentValue=" + this.getCurrentValue() + ", paramName=" + this.getParamName() + ", paramNamePre=" + this.getParamNamePre() + ", isCount=" + this.isCount() + ")";
    }
}

