/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.dao;

import cn.isqing.icloud.common.api.enums.ResCodeEnum;
import cn.isqing.icloud.common.utils.dao.ConditionParser;
import cn.isqing.icloud.common.utils.dao.SQL;
import cn.isqing.icloud.common.utils.dto.BaseException;
import cn.isqing.icloud.common.utils.sql.SqlUtil;
import cn.isqing.icloud.common.utils.time.TimeUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseProvider<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseProvider.class);
    private String simpleTpl = "`%s`=#{%s%s}";
    private long lockMinutes = 10L;
    private static final String ERR_MSG = "\u89e3\u6790sql\u5f02\u5e38";

    public String lock(T t) {
        SQL sql = new SQL();
        sql.UPDATE(SqlUtil.getTableName(t.getClass(), false));
        sql.SET("lock_version = lock_version+1");
        String nowTime = TimeUtil.now().plusMinutes(this.lockMinutes).format(TimeUtil.dateTimeFormatter);
        sql.SET("lock_time = '" + nowTime + "'");
        sql.SET("lock_status = 1");
        sql.WHERE("id = #{id}");
        sql.WHERE("status = 0");
        sql.WHERE("lock_version = #{lockVersion}");
        return sql.toString();
    }

    public String unlock(T t) {
        SQL sql = new SQL();
        sql.UPDATE(SqlUtil.getTableName(t.getClass(), false));
        sql.SET("lock_version = lock_version+1");
        sql.SET("lock_status = 0");
        sql.WHERE("id = #{id}");
        sql.WHERE("status = 1");
        sql.WHERE("lock_version = #{lockVersion}");
        return sql.toString();
    }

    public String insert(T object) {
        Field[] fields;
        SQL sql = new SQL();
        Class<?> aClass = object.getClass();
        sql.INSERT_INTO(SqlUtil.getTableName(aClass, false));
        for (Field field : fields = aClass.getDeclaredFields()) {
            Object v;
            field.setAccessible(true);
            try {
                v = field.get(object);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BaseException(ResCodeEnum.SYSTEM_ERROR.getCode(), ERR_MSG);
            }
            if (v == null) continue;
            String fieldName = field.getName();
            String[] arr = SqlUtil.getFieldName(fieldName, false);
            sql.VALUES(arr[0], "#{" + fieldName + "}");
        }
        return sql.toString();
    }

    public String del(T object) {
        SQL sql = new SQL();
        sql.DELETE_FROM(SqlUtil.getTableName(object.getClass(), false));
        sql.WHERE(this.getKV(object, null));
        return sql.toString();
    }

    public String delById(@Param(value="id") Long id, @Param(value="c") Class<T> c) {
        SQL sql = new SQL();
        sql.DELETE_FROM(SqlUtil.getTableName(c, false));
        sql.WHERE("id = #{id}");
        return sql.toString();
    }

    public String delByCondition(T object) {
        SQL sql = new SQL();
        sql.DELETE_FROM(SqlUtil.getTableName(object.getClass(), true));
        sql.WHERE(this.getConditionKV(sql, object));
        return sql.toString();
    }

    public String update(T object) {
        SQL sql = new SQL();
        sql.UPDATE(SqlUtil.getTableName(object.getClass(), false));
        String[] list = this.getKV(object, null);
        String[] data = (String[])Arrays.stream(list).filter(v -> !v.startsWith("id=") && !v.startsWith("id =")).toArray(String[]::new);
        sql.SET(data);
        sql.WHERE("id = #{id}");
        return sql.toString();
    }

    public String updateByCondition(@Param(value="t") T t, @Param(value="c") Object condition) {
        SQL sql = new SQL();
        sql.UPDATE(SqlUtil.getTableName(t.getClass(), false));
        sql.SET(this.getKV(t, "t"));
        sql.WHERE(this.getConditionKV(sql, condition, "c", null));
        return sql.toString();
    }

    public String select(@Param(value="t") T t, @Param(value="fields") String fields, @Param(value="order") String order) {
        SQL sql = new SQL();
        if (fields == null) {
            fields = "*";
        }
        sql.SELECT(fields);
        sql.FROM(SqlUtil.getTableName(t.getClass(), false));
        sql.WHERE(this.getKV(t, "t"));
        if (!StringUtils.isBlank((CharSequence)order)) {
            sql.ORDER_BY(order);
        }
        return sql.toString();
    }

    public String selectByCondition(Object condition) {
        SQL sql = new SQL();
        sql.FROM(SqlUtil.getTableName(condition.getClass(), true));
        sql.SELECT("*");
        sql.WHERE(this.getConditionKV(sql, condition));
        return sql.toString();
    }

    public String leftJoinSelect(@Param(value="left") Object left, @Param(value="right") Object right, @Param(value="join") String join) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(left.getClass(), true) + " as l");
        sql.LEFT_OUTER_JOIN(SqlUtil.getTableName(right.getClass(), true) + " as r on " + join);
        sql.WHERE(this.getConditionKV(sql, left, "left", "l"));
        sql.WHERE(this.getConditionKV(sql, right, "right", "r"));
        return sql.toString();
    }

    public String leftJoinCount(@Param(value="left") Object left, @Param(value="right") Object right, @Param(value="join") String join) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(SqlUtil.getTableName(left.getClass(), true) + " as l");
        sql.LEFT_OUTER_JOIN(SqlUtil.getTableName(right.getClass(), true) + " as r on " + join);
        sql.WHERE(this.getConditionKV(sql, left, "left", "l", true));
        sql.WHERE(this.getConditionKV(sql, right, "right", "r", true));
        return sql.toString();
    }

    public String innerJoinSelect(@Param(value="left") Object left, @Param(value="right") Object right, @Param(value="join") String join) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(left.getClass(), true) + " as l");
        sql.INNER_JOIN(SqlUtil.getTableName(right.getClass(), true) + " as r on " + join);
        sql.WHERE(this.getConditionKV(sql, left, "left", "l"));
        sql.WHERE(this.getConditionKV(sql, right, "right", "r"));
        return sql.toString();
    }

    public String innerJoinCount(@Param(value="left") Object left, @Param(value="right") Object right, @Param(value="join") String join) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(SqlUtil.getTableName(left.getClass(), true) + " as l");
        sql.INNER_JOIN(SqlUtil.getTableName(right.getClass(), true) + " as r on " + join);
        sql.WHERE(this.getConditionKV(sql, left, "left", "l", true));
        sql.WHERE(this.getConditionKV(sql, right, "right", "r", true));
        return sql.toString();
    }

    public String count(T t) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(SqlUtil.getTableName(t.getClass(), false));
        sql.WHERE(this.getKV(t, null));
        return sql.toString();
    }

    public String countByCondition(Object c) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(SqlUtil.getTableName(c.getClass(), true));
        sql.WHERE(this.getConditionKV(sql, c, null, null, true));
        return sql.toString();
    }

    public String countAll(Class<T> c) {
        SQL sql = new SQL();
        sql.SELECT("count(1)");
        sql.FROM(SqlUtil.getTableName(c, false));
        return sql.toString();
    }

    public String getScrollList(@Param(value="t") T t, @Param(value="from") Long from, @Param(value="limit") Integer limit, @Param(value="order") String order) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(t.getClass(), true));
        if (from != null) {
            sql.WHERE("id>" + from);
        }
        sql.WHERE(this.getKV(t, "t"));
        if (!StringUtils.isBlank((CharSequence)order)) {
            sql.ORDER_BY(order);
        }
        sql.LIMIT(limit);
        return sql.toString();
    }

    public String getPageList(@Param(value="t") T t, @Param(value="limit") Integer limit, @Param(value="offset") Integer offset, @Param(value="order") String order) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(t.getClass(), true));
        sql.WHERE(this.getKV(t, "t"));
        if (!StringUtils.isBlank((CharSequence)order)) {
            sql.ORDER_BY(order);
        }
        sql.LIMIT(limit);
        sql.OFFSET(offset.intValue());
        return sql.toString();
    }

    public String getPageListSimple(@Param(value="c") Class<T> c, @Param(value="limit") Integer limit, @Param(value="offset") Integer offset, @Param(value="order") String order) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(c, true));
        if (!StringUtils.isBlank((CharSequence)order)) {
            sql.ORDER_BY(order);
        }
        sql.LIMIT(limit);
        sql.OFFSET(offset.intValue());
        return sql.toString();
    }

    public String first(@Param(value="t") T t, @Param(value="order") String order) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(t.getClass(), true));
        sql.WHERE(this.getKV(t, "t"));
        if (!StringUtils.isBlank((CharSequence)order)) {
            sql.ORDER_BY(order);
        }
        sql.LIMIT(1);
        return sql.toString();
    }

    public String selectById(@Param(value="id") Long id, @Param(value="c") Class<T> c) {
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(SqlUtil.getTableName(c, true));
        sql.WHERE("id = #{id}");
        sql.LIMIT(1);
        return sql.toString();
    }

    private String[] getKV(T object, String pre) {
        Field[] fields;
        pre = pre == null ? "" : pre + ".";
        ArrayList<String> list = new ArrayList<String>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            Object v;
            field.setAccessible(true);
            try {
                v = field.get(object);
            }
            catch (IllegalAccessException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BaseException(ResCodeEnum.SYSTEM_ERROR.getCode(), ERR_MSG);
            }
            if (v == null) continue;
            String fieldName = field.getName();
            String[] arr = SqlUtil.getFieldName(fieldName, false);
            list.add(String.format(this.simpleTpl, arr[0], pre, fieldName));
        }
        return list.toArray(new String[0]);
    }

    private String[] getConditionKV(SQL sql, Object object) {
        return this.getConditionKV(sql, object, null, null, false);
    }

    private String[] getConditionKV(SQL sql, Object object, String parameterName, String tableAlais) {
        return this.getConditionKV(sql, object, parameterName, tableAlais, false);
    }

    private String[] getConditionKV(SQL sql, Object object, String parameterName, String tableAlais, boolean isCount) {
        ConditionParser dto = new ConditionParser();
        dto.setCount(isCount);
        dto.setParamName(parameterName);
        dto.setTableAlias(tableAlais);
        dto.setSql(sql);
        dto.setObject(object);
        dto.setList(new ArrayList<Object>());
        dto.parse();
        return dto.getList().toArray(new String[0]);
    }
}

