/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.time.ratelimiter;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TokenBucketRatelimiter {
    private static long rate = 20L;
    private static long timeUnit = 1000000000L;
    private static long capacity = 100L;
    private static final AtomicLong bucket = new AtomicLong();
    private static long refreshTime = System.nanoTime();
    private static Lock lock = new ReentrantLock();

    private TokenBucketRatelimiter() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean tryAcquire() {
        long nowTime = System.nanoTime();
        try {
            if (nowTime - refreshTime > timeUnit && lock.tryLock(1L, TimeUnit.SECONDS) && nowTime - refreshTime > timeUnit) {
                refreshTime = nowTime;
                long tokenNum = (nowTime - refreshTime) / timeUnit * rate;
                long now = bucket.get();
                if (now + tokenNum > capacity) {
                    bucket.set(capacity - now);
                } else {
                    bucket.set(tokenNum);
                }
            }
        }
        catch (InterruptedException e) {
            return false;
        }
        if (bucket.get() <= 0L) {
            return false;
        }
        long l = bucket.decrementAndGet();
        return l >= 0L;
    }
}

