/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.time.ratelimiter;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SlidingWindowsRatelimiter {
    private static long timeUnit = 60L;
    private static int subTimeLimt = 10;
    private static long numLimit = 100L;
    private static long nanoUnit = 1000000000L;
    private static final Map<Long, AtomicLong> map = new ConcurrentHashMap<Long, AtomicLong>();

    private SlidingWindowsRatelimiter() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean tryAcquire() {
        long secondsTime = System.nanoTime() / nanoUnit;
        long windowsIndex = secondsTime / (long)subTimeLimt;
        long windowsIndexStart = (secondsTime - timeUnit) / (long)subTimeLimt;
        AtomicLong num = map.get(windowsIndex);
        if (num == null) {
            map.putIfAbsent(windowsIndex, new AtomicLong());
            num = map.get(windowsIndex);
        }
        long total = 0L;
        Iterator<Long> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long next = iterator.next();
            if (next < windowsIndexStart) {
                iterator.remove();
                continue;
            }
            if (next > windowsIndex) continue;
            total += map.get(next).get();
        }
        if (total > numLimit) {
            return false;
        }
        num.incrementAndGet();
        return true;
    }
}

