/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.time.ratelimiter;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LeakyBucketRatelimiter {
    private static long rate = 20L;
    private static long timeUnit = 1000000000L;
    private static long capacity = 100L;
    private static final AtomicLong bucket = new AtomicLong();
    private static long refreshTime = System.nanoTime();
    private static Lock lock = new ReentrantLock();

    private LeakyBucketRatelimiter() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean tryAcquire() {
        long nowTime = System.nanoTime();
        if (nowTime - refreshTime > timeUnit && lock.tryLock() && nowTime - refreshTime > timeUnit) {
            refreshTime = nowTime;
            bucket.set(rate);
            lock.unlock();
        }
        if (bucket.get() <= 0L) {
            return false;
        }
        long l = bucket.decrementAndGet();
        return l >= 0L;
    }
}

