/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.sql;

import cn.hutool.cache.CacheUtil;
import cn.hutool.cache.impl.LRUCache;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SqlUtil {
    public static final String TABLE_QUOTES = "`";
    public static final String TABLE_CONDITION_SUF = "_condition";
    public static final String FIELD_CONDITION_SUF = "_condition";
    public static final int FIELD_CONDITION_SUF_LENGTH = 10;
    private static int tableCapacity = 100;
    private static int filedCapacity = 500;
    private static final LRUCache<String, String> TABLE_NAME = CacheUtil.newLRUCache((int)tableCapacity);
    private static final LRUCache<String, String[]> FILED_NAME = CacheUtil.newLRUCache((int)filedCapacity);

    public static <T> String getTableName(Class<T> aClass, boolean isCondition) {
        int i;
        String s = (String)TABLE_NAME.get((Object)(aClass.getSimpleName() + isCondition));
        if (s != null) {
            return s;
        }
        String simpleName = aClass.getSimpleName();
        s = SqlUtil.snakeCaseToUnderline(simpleName);
        s = TABLE_QUOTES + s + TABLE_QUOTES;
        if (isCondition && (i = s.lastIndexOf("_condition")) != -1) {
            s = s.substring(0, i) + TABLE_QUOTES;
        }
        TABLE_NAME.put((Object)(simpleName + isCondition), (Object)s);
        return s;
    }

    public static String[] getFieldName(String fieldName, boolean isCondition) {
        int i;
        String name;
        String[] arr = (String[])FILED_NAME.get((Object)(fieldName + isCondition));
        if (arr != null) {
            return arr;
        }
        String pre = name = SqlUtil.snakeCaseToUnderline(fieldName);
        String suf = "";
        arr = new String[2];
        if (isCondition && (i = name.lastIndexOf("_condition")) != -1) {
            pre = name.substring(0, i);
            suf = name.substring(i + 10);
        }
        arr[0] = pre;
        arr[1] = suf;
        FILED_NAME.put((Object)(fieldName + isCondition), (Object)arr);
        return arr;
    }

    public static String snakeCaseToUnderline(String input) {
        int length = input.length();
        StringBuilder result = new StringBuilder(length * 2);
        int resultLength = 0;
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (i <= 0 && c == '_') continue;
            if (Character.isUpperCase(c)) {
                if (resultLength > 0 && result.charAt(resultLength - 1) != '_') {
                    result.append('_');
                    ++resultLength;
                }
                c = Character.toLowerCase(c);
            }
            result.append(c);
            ++resultLength;
        }
        return resultLength > 0 ? result.toString() : input;
    }

    private SqlUtil() {
    }

    public static String escapeSqlValue(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return str;
        }
        str = str.replace("\\", "\\\\");
        str = str.replace("'", "\\'");
        str = str.replace("\"", "\\\"");
        return str;
    }

    public static String getSqlIn(List<String> list) {
        return "('" + StringUtils.join((Object[])list.stream().map(SqlUtil::escapeSqlValue).toArray(), (String)"','") + "')";
    }

    public static String getLongSqlIn(List<Long> list) {
        return "(" + StringUtils.join((Object[])list.toArray(), (String)",") + ")";
    }

    public static String getIntegerSqlIn(List<Integer> list) {
        return "(" + StringUtils.join((Object[])list.toArray(), (String)",") + ")";
    }

    public static int getTableCapacity() {
        return tableCapacity;
    }

    public static void setTableCapacity(int tableCapacity) {
        SqlUtil.tableCapacity = tableCapacity;
    }

    public static int getFiledCapacity() {
        return filedCapacity;
    }

    public static void setFiledCapacity(int filedCapacity) {
        SqlUtil.filedCapacity = filedCapacity;
    }
}

