/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.log;

import cn.isqing.icloud.common.utils.uuid.UuidUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class MDCUtil {
    private static final Logger log = LoggerFactory.getLogger(MDCUtil.class);
    private static String TRACE_ID_FIELD = "tid";
    private static String SEPARATOR = "|";

    public static void setTraceIdField(String fieldName) {
        TRACE_ID_FIELD = fieldName;
    }

    public static void appendTraceId() {
        try {
            String pid = MDC.get((String)TRACE_ID_FIELD);
            String traceId = "";
            if (!StringUtils.isBlank((CharSequence)pid)) {
                traceId = pid + SEPARATOR;
            }
            traceId = traceId + UuidUtil.randomNum_6();
            MDC.put((String)TRACE_ID_FIELD, (String)traceId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void cancelAppendTraceId() {
        try {
            String traceId = MDC.get((String)TRACE_ID_FIELD);
            if (traceId == null) {
                return;
            }
            int i = traceId.lastIndexOf(SEPARATOR);
            if (i != -1) {
                traceId = traceId.substring(0, i);
                MDC.put((String)TRACE_ID_FIELD, (String)traceId);
            } else {
                MDC.remove((String)TRACE_ID_FIELD);
            }
        }
        catch (IllegalArgumentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

