/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.kit;

import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MqUtil {
    private static final Logger log = LoggerFactory.getLogger(MqUtil.class);
    private static RocketMQTemplate mqTemplate;

    @Autowired
    public void setMqTemplate(RocketMQTemplate mqTemplate) {
        MqUtil.mqTemplate = mqTemplate;
    }

    public static void asyncSend(final String destination, final Object msg) {
        try {
            mqTemplate.asyncSend(destination, msg, new SendCallback(){

                public void onSuccess(SendResult sendResult) {
                    if (!sendResult.getSendStatus().equals((Object)SendStatus.SEND_OK)) {
                        log.info("\u53d1\u9001\u6d88\u606f\u5931\u8d25:destination:{},msg:{},sendStatus:{}", new Object[]{destination, msg, sendResult.getSendStatus()});
                    } else {
                        log.info("\u53d1\u9001\u6d88\u606f\u6210\u529f:destinationc:{},msg:{}", (Object)destination, msg);
                    }
                }

                public void onException(Throwable throwable) {
                    log.info("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:destination:{},msg:{}", (Object)destination, msg);
                    log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38:" + throwable.getMessage(), throwable);
                }
            });
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
        }
    }
}

