/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.kit;

import cn.isqing.icloud.common.utils.dao.BaseMapper;
import cn.isqing.icloud.common.utils.enums.status.YesOrNo;
import cn.isqing.icloud.common.utils.flow.FlowContext;
import cn.isqing.icloud.common.utils.time.TimeUtil;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class LockUtil {
    private static final Logger log = LoggerFactory.getLogger(LockUtil.class);
    private static final Map<FlowContext, Map<Object, BaseMapper>> DO_LOCK_MAP = new ConcurrentHashMap<FlowContext, Map<Object, BaseMapper>>();
    private static final ThreadPoolTaskExecutor jobRxecutor = new ThreadPoolTaskExecutor();
    private static final ScheduledExecutorService excutor;
    public static RedissonClient redissonClient;

    @Autowired
    public void setRedissonClient(RedissonClient redissonClient) {
        LockUtil.redissonClient = redissonClient;
    }

    public static RLock getRedisLock(String key) {
        return LockUtil.getRedisLock(key, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tryRunWithRLock(String key, long time, TimeUnit unit, Predicate predicate, Consumer consumer) {
        RLock rLock = LockUtil.getRedisLock(key, time, unit);
        if (rLock == null) {
            log.info("\u672a\u83b7\u53d6\u5230\u9501\u53d6\u6d88\u6267\u884c");
            return;
        }
        try {
            boolean test = predicate.test(null);
            if (test) {
                consumer.accept(null);
            }
        }
        finally {
            try {
                rLock.unlock();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static RLock getRedisLock(String key, long time, TimeUnit unit) {
        RLock lock = redissonClient.getLock(key);
        try {
            boolean locked = lock.tryLock(time, unit);
            if (locked) {
                return lock;
            }
        }
        catch (InterruptedException e) {
            log.warn(e.getMessage(), (Throwable)e);
            Thread.currentThread().interrupt();
            Thread.interrupted();
        }
        return null;
    }

    public static boolean lockPo(FlowContext context, Object dataPo, BaseMapper mapper) throws Exception {
        Class<?> aClass = dataPo.getClass();
        Method getLockStatus = aClass.getMethod("getLockStatus", new Class[0]);
        Method getLockTime = aClass.getMethod("getLockTime", new Class[0]);
        if (getLockStatus.invoke(dataPo, new Object[0]).equals(YesOrNo.YES.ordinal()) && ((LocalDateTime)getLockTime.invoke(dataPo, new Object[0])).isAfter(TimeUtil.now())) {
            return false;
        }
        Method setLockVersion = aClass.getMethod("setLockVersion", Long.class);
        Method getLockVersion = aClass.getMethod("getLockVersion", new Class[0]);
        int lock = mapper.lock(dataPo);
        if (lock > 0) {
            setLockVersion.invoke(dataPo, (Long)getLockVersion.invoke(dataPo, new Object[0]) + 1L);
            Map mapperMap = DO_LOCK_MAP.computeIfAbsent(context, k -> new ConcurrentHashMap());
            mapperMap.put(dataPo, mapper);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unlockPo(FlowContext context, Object dataPo, BaseMapper mapper) {
        Method getLockVersion;
        Method setLockVersion;
        Class<?> aClass = dataPo.getClass();
        try {
            setLockVersion = aClass.getMethod("setLockVersion", Long.class);
            getLockVersion = aClass.getMethod("getLockVersion", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
        int lock = mapper.unlock(dataPo);
        boolean res = false;
        if (lock > 0) {
            try {
                setLockVersion.invoke(dataPo, (Long)getLockVersion.invoke(dataPo, new Object[0]) + 1L);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            res = true;
        }
        Map<Object, BaseMapper> map = DO_LOCK_MAP.get(context);
        Object object = dataPo;
        synchronized (object) {
            map.remove(dataPo);
        }
        if (map.isEmpty()) {
            DO_LOCK_MAP.remove(context);
        }
        return res;
    }

    public static boolean renewalDo(Object dataDo, BaseMapper mapper) throws Exception {
        Class<?> aClass = dataDo.getClass();
        Method setLockVersion = aClass.getMethod("setLockVersion", Long.class);
        Method getLockVersion = aClass.getMethod("getLockVersion", new Class[0]);
        int lock = mapper.lock(dataDo);
        if (lock > 0) {
            setLockVersion.invoke(dataDo, (Long)getLockVersion.invoke(dataDo, new Object[0]) + 1L);
            return true;
        }
        return false;
    }

    static {
        jobRxecutor.setThreadNamePrefix("do-watchdog");
        jobRxecutor.setMaxPoolSize(120);
        jobRxecutor.setCorePoolSize(64);
        jobRxecutor.setQueueCapacity(600);
        jobRxecutor.setAllowCoreThreadTimeOut(true);
        jobRxecutor.setKeepAliveSeconds(300);
        jobRxecutor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.AbortPolicy());
        excutor = Executors.newSingleThreadScheduledExecutor();
        excutor.scheduleAtFixedRate(() -> {
            for (Map.Entry<FlowContext, Map<Object, BaseMapper>> next : DO_LOCK_MAP.entrySet()) {
                jobRxecutor.submit(() -> {
                    if (((FlowContext)next.getKey()).isFlowEnd()) {
                        DO_LOCK_MAP.remove(next.getKey());
                        return;
                    }
                    for (Map.Entry next1 : ((Map)next.getValue()).entrySet()) {
                        Object k = next1.getKey();
                        synchronized (k) {
                            if (((Map)next.getValue()).containsKey(next1.getKey())) {
                                try {
                                    LockUtil.renewalDo(next1.getKey(), (BaseMapper)next1.getValue());
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                });
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }
}

