/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.flow;

import cn.isqing.icloud.common.api.dto.Response;
import cn.isqing.icloud.common.utils.flow.FlowContext;
import cn.isqing.icloud.common.utils.json.JsonUtil;
import cn.isqing.icloud.common.utils.log.MDCUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowTemplate<T extends FlowContext, R> {
    private static final Logger log = LoggerFactory.getLogger(FlowTemplate.class);
    private String stepLog = "\u6267\u884c\u6b65\u9aa4:{}";
    private List<Step> steps = new ArrayList<Step>();
    private String flowName;
    private String flowClassName;
    private Consumer<T> errorAccept;
    private Function<T, Response<R>> errorApply;
    private Consumer<T> finallyAccept;
    private String finallyAcceptName;
    private Function<T, Response<R>> finallyApply;
    private String finallyApplyName;

    protected void start(String flowName, Object flow) {
        this.flowName = flowName;
        this.flowClassName = flow.getClass().getSimpleName();
    }

    protected void errorAccept(Consumer<T> accept) {
        this.errorAccept = accept;
    }

    protected void errorApply(Function<T, Response<R>> apply) {
        this.errorApply = apply;
    }

    protected void finallyAccept(Consumer<T> accept) {
        this.finallyAccept = accept;
    }

    protected void finallyAcceptName(String name) {
        this.finallyAcceptName = name;
    }

    protected void finallyApply(Function<T, Response<R>> apply) {
        this.finallyApply = apply;
    }

    protected void finallyApplyName(String name) {
        this.finallyApplyName = name;
    }

    protected void stepName(String name) {
        Step step = new Step();
        step.setName(name);
        this.steps.add(step);
    }

    protected void test(Predicate<T> test) {
        Step step = this.steps.get(this.steps.size() - 1);
        step.test = test;
    }

    protected void accept(Consumer<T> accept) {
        Step step = this.steps.get(this.steps.size() - 1);
        step.accept = accept;
    }

    protected void apply(Function<T, Response<R>> apply) {
        Step step = this.steps.get(this.steps.size() - 1);
        step.apply = apply;
    }

    protected void interrupt(T context, Response<R> res) {
        ((FlowContext)context).setInterrupted(true);
        ((FlowContext)context).setFlowRes(res);
    }

    public final Response<R> exec(T context) {
        MDCUtil.appendTraceId();
        log.info("\u5f00\u59cb\u6d41\u7a0b:{}[{}]", (Object)this.flowName, (Object)this.flowClassName);
        if (((FlowContext)context).isLog()) {
            log.info("\u5165\u53c2:{}", (Object)this.getString(context));
        }
        try {
            for (Step step : this.steps) {
                this.execStep(step, context);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            log.info("\u6267\u884cfinally:");
            Optional.ofNullable(this.finallyAcceptName).ifPresent(name -> log.info(this.stepLog, name));
            Optional.ofNullable(this.finallyAccept).ifPresent(f -> f.accept(context));
            Optional.ofNullable(this.finallyApplyName).ifPresent(name -> log.info(this.stepLog, name));
            Optional.ofNullable(this.finallyApply).ifPresent(f -> context.setFlowRes((Response)f.apply(context)));
            log.info("\u7ed3\u675f\u6d41\u7a0b");
            if (((FlowContext)context).isLog()) {
                log.info("\u6700\u7ec8\u4e0a\u4e0b\u6587:{}", (Object)this.getString(context));
            }
            MDCUtil.cancelAppendTraceId();
        }
        if (((FlowContext)context).getFlowErrorRes() != null) {
            return ((FlowContext)context).getFlowErrorRes();
        }
        if (((FlowContext)context).getFlowRes() == null) {
            return Response.SUCCESS;
        }
        return ((FlowContext)context).getFlowRes();
    }

    private void execStep(Step step, T context) {
        block4: {
            if (((FlowContext)context).isInterrupted()) {
                log.info("isInterrupted=true\u8df3\u8fc7\u6b65\u9aa4:{}", (Object)step.getName());
                return;
            }
            if (step.getTest() != null && !step.getTest().test(context)) {
                log.info("\u8df3\u8fc7\u6b65\u9aa4:{}", (Object)step.getName());
                return;
            }
            log.info(this.stepLog, (Object)step.getName());
            try {
                Optional.ofNullable(step.getAccept()).ifPresent(f -> f.accept(context));
                Optional.ofNullable(step.getApply()).ifPresent(f -> context.setFlowRes((Response)f.apply(context)));
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u6b65\u9aa4[{}]\u5f02\u5e38:{}", (Object)step.getName(), (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                ((FlowContext)context).setInterrupted(true);
                Optional.ofNullable(this.errorAccept).ifPresent(f -> {
                    log.info("\u6267\u884cerrorAccept");
                    f.accept(context);
                });
                Optional.ofNullable(this.errorApply).ifPresent(f -> {
                    log.info("\u6267\u884cerrorApply");
                    context.setFlowErrorRes((Response)f.apply(context));
                });
                if (((FlowContext)context).getFlowErrorRes() != null) break block4;
                ((FlowContext)context).setFlowEnd(true);
                throw e;
            }
        }
    }

    private String getString(T context) {
        return JsonUtil.toJsonString(context);
    }

    private class Step {
        private String name;
        private Predicate<T> test;
        private Consumer<T> accept;
        private Function<T, Response<R>> apply;

        public String getName() {
            return this.name;
        }

        public Predicate<T> getTest() {
            return this.test;
        }

        public Consumer<T> getAccept() {
            return this.accept;
        }

        public Function<T, Response<R>> getApply() {
            return this.apply;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTest(Predicate<T> test) {
            this.test = test;
        }

        public void setAccept(Consumer<T> accept) {
            this.accept = accept;
        }

        public void setApply(Function<T, Response<R>> apply) {
            this.apply = apply;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step)) {
                return false;
            }
            Step other = (Step)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Predicate this$test = this.getTest();
            Predicate other$test = other.getTest();
            if (this$test == null ? other$test != null : !this$test.equals(other$test)) {
                return false;
            }
            Consumer this$accept = this.getAccept();
            Consumer other$accept = other.getAccept();
            if (this$accept == null ? other$accept != null : !this$accept.equals(other$accept)) {
                return false;
            }
            Function this$apply = this.getApply();
            Function other$apply = other.getApply();
            return !(this$apply == null ? other$apply != null : !this$apply.equals(other$apply));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Step;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Predicate $test = this.getTest();
            result = result * 59 + ($test == null ? 43 : $test.hashCode());
            Consumer $accept = this.getAccept();
            result = result * 59 + ($accept == null ? 43 : $accept.hashCode());
            Function $apply = this.getApply();
            result = result * 59 + ($apply == null ? 43 : $apply.hashCode());
            return result;
        }

        public String toString() {
            return "FlowTemplate.Step(name=" + this.getName() + ", test=" + this.getTest() + ", accept=" + this.getAccept() + ", apply=" + this.getApply() + ")";
        }
    }
}

