/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.utils.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SpringBeanUtils
extends BeanUtils {
    private static final Map<String, ApplicationContext> contextMap = new HashMap<String, ApplicationContext>();

    public static ApplicationContext getContext(String name) {
        return contextMap.get(name);
    }

    public static void setContext(String name, ApplicationContext context) {
        contextMap.put(name, context);
    }

    public static void main(String[] args) {
    }

    public static void copyProperties(Object source, Object target) throws BeansException {
        SpringBeanUtils.copyProperties(source, target, null, null);
    }

    private static void copyProperties(Object source, Object target, @Nullable Class<?> editable, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = SpringBeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            boolean isAssignable;
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = SpringBeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null) continue;
            ResolvableType sourceResolvableType = ResolvableType.forMethodReturnType((Method)readMethod);
            ResolvableType targetResolvableType = ResolvableType.forMethodParameter((Method)writeMethod, (int)0);
            boolean bl = isAssignable = sourceResolvableType.hasUnresolvableGenerics() || targetResolvableType.hasUnresolvableGenerics() ? ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType()) : targetResolvableType.isAssignableFrom(sourceResolvableType);
            if (!isAssignable) continue;
            try {
                Object value;
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }
}

