/*
 * Decompiled with CFR 0.152.
 */
package cn.isqing.icloud.common.api.dto;

import cn.isqing.icloud.common.api.enums.ResCodeEnum;
import java.io.Serializable;

public class Response<T>
implements Serializable {
    private String code;
    private String msg;
    private T data;
    public static final Response<Object> SUCCESS = new Response(ResCodeEnum.SUCCESS.getCode(), "\u6210\u529f");
    public static final Response<Object> ERROR = new Response(ResCodeEnum.ERROR.getCode(), "\u5f02\u5e38");

    public Response(String code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public Response(String code) {
        this.code = code;
    }

    public Response(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    public static <T> Response<T> info(String code, String msg) {
        return new Response<T>(code, msg);
    }

    public static <T> Response<T> info(String code, String msg, T data) {
        return new Response<T>(code, msg, data);
    }

    public static <T> Response<T> error(String msg) {
        return new Response<T>(ResCodeEnum.ERROR.getCode(), msg);
    }

    public static <T> Response<T> error(String msg, T data) {
        return new Response<T>(ResCodeEnum.ERROR.getCode(), msg, data);
    }

    public static <R> Response<R> withData(Response res, R data) {
        res.setData(data);
        return res;
    }

    public static <T> Response<T> success(String msg) {
        return new Response<T>(ResCodeEnum.SUCCESS.getCode(), msg);
    }

    public static <T> Response<T> success(String msg, T data) {
        return new Response<T>(ResCodeEnum.SUCCESS.getCode(), msg, data);
    }

    public static <T> Response<T> success(T data) {
        return new Response<T>(ResCodeEnum.SUCCESS.getCode(), ResCodeEnum.SUCCESS.getMsg(), data);
    }

    public boolean isSuccess() {
        return ResCodeEnum.SUCCESS.getCode().equals(this.code);
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

