/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.reactive.configuration;

import cn.is4j.insp.core.exception.InspException;
import cn.is4j.insp.core.exception.InspExceptionTranslator;
import cn.is4j.insp.core.intercept.aopalliance.InspAnnotationBeanPostProcessor;
import cn.is4j.insp.reactive.filter.ReactiveRequestContextFilter;
import cn.is4j.insp.reactive.intercept.aopalliance.MethodInspReactiveInterceptor;
import cn.is4j.insp.reactive.service.InspReactiveAuthenticationService;
import org.aopalliance.intercept.MethodInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@Configuration
public class InspReactiveConfiguration {
    private InspReactiveAuthenticationService authenticationService;
    private InspExceptionTranslator inspExceptionTranslator;

    @Autowired(required=false)
    public void setAuthenticationService(InspReactiveAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    @Autowired(required=false)
    public void setInspExceptionTranslator(InspExceptionTranslator inspExceptionTranslator) {
        this.inspExceptionTranslator = inspExceptionTranslator;
    }

    @Bean
    public ReactiveRequestContextFilter reactiveRequestContextFilter() {
        return new ReactiveRequestContextFilter();
    }

    @Bean
    @ConditionalOnMissingBean
    public MethodInspReactiveInterceptor methodInspInterceptor() {
        if (null == this.authenticationService) {
            throw new InspException("required a bean of type '" + InspReactiveAuthenticationService.class.getName() + "' that could not be found");
        }
        return new MethodInspReactiveInterceptor(this.authenticationService, this.inspExceptionTranslator);
    }

    @Bean
    public InspAnnotationBeanPostProcessor inspAnnotationBeanPostProcessor(MethodInspReactiveInterceptor methodInspWebInterceptor) {
        return new InspAnnotationBeanPostProcessor((MethodInterceptor)methodInspWebInterceptor);
    }
}

