/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.expression;

import cn.is4j.insp.core.expression.InspExpressionOperations;
import cn.is4j.insp.core.service.InspAuthentication;
import java.util.Arrays;
import java.util.List;

public class InspExpressionRoot
implements InspExpressionOperations {
    private InspAuthentication authentication;

    @Override
    public boolean hasFuncData(String[] funcAuthorities, String[] dataAuthorities) {
        return this.hasFunc(funcAuthorities) && this.hasData(dataAuthorities);
    }

    @Override
    public boolean hasFunc(String[] funcAuthorities) {
        return this.matches(true, this.authentication.getFuncAuthorities(), funcAuthorities);
    }

    @Override
    public boolean hasAnyFunc(String[] funcAuthorities) {
        return this.matches(false, this.authentication.getFuncAuthorities(), funcAuthorities);
    }

    @Override
    public boolean hasData(String[] dataAuthorities) {
        return this.matches(true, this.authentication.getDataAuthorities(), dataAuthorities);
    }

    @Override
    public boolean hasAnyData(String[] dataAuthorities) {
        return this.matches(false, this.authentication.getDataAuthorities(), dataAuthorities);
    }

    @Override
    public boolean hasRole(String[] roles) {
        return this.matches(true, this.authentication.getRoles(), roles);
    }

    @Override
    public boolean hasAnyRole(String[] roles) {
        return this.matches(false, this.authentication.getRoles(), roles);
    }

    private boolean matches(boolean allMatches, List<String> authenticationAuthorities, String ... inspAuthorities) {
        if (this.authentication.isHighestAuth()) {
            return true;
        }
        if (null == inspAuthorities) {
            return false;
        }
        return allMatches ? Arrays.stream(inspAuthorities).allMatch(authenticationAuthorities::contains) : Arrays.stream(inspAuthorities).anyMatch(authenticationAuthorities::contains);
    }

    public InspExpressionRoot(InspAuthentication authentication) {
        this.authentication = authentication;
    }

    @Override
    public void setAuthentication(InspAuthentication authentication) {
        this.authentication = authentication;
    }
}

