/*
 * Copyright 2020-2021 zengzhihong All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.is4j.insp.core.expression;

import cn.is4j.insp.core.intercept.aopalliance.InspInterceptor;
import lombok.AllArgsConstructor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

@AllArgsConstructor
public class InspExpressionInvocationHandler implements InvocationHandler {

    private final InspInterceptor inspInterceptor;
    private final InspMetadataSource metadataSource;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        // todo deprecated on 2.x
        metadataSource.setExpressionArgs(args);
        InspExpressionOperations operations = new InspExpressionRoot(inspInterceptor.onAuthentication(metadataSource));
        return method.invoke(operations, args);
    }
}