/*
 * Decompiled with CFR 0.152.
 */
package cn.is4j.insp.core.service;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class InspAuthentication
implements Serializable {
    private String id;
    private List<String> funcAuthorities;
    private List<String> dataAuthorities;
    private List<String> roles;
    private boolean highestAuth = false;

    public InspAuthentication() {
    }

    public InspAuthentication(String id, List<String> funcAuthorities, List<String> dataAuthorities) {
        this(id, funcAuthorities, dataAuthorities, null);
    }

    public InspAuthentication(String id, List<String> funcAuthorities, List<String> dataAuthorities, List<String> roles) {
        this.id = id;
        this.funcAuthorities = this.defaultEmptyListIfNull(funcAuthorities);
        this.dataAuthorities = this.defaultEmptyListIfNull(dataAuthorities);
        this.roles = this.defaultEmptyListIfNull(roles);
    }

    public static InspAuthentication createHighestAuth(String id) {
        InspAuthentication authentication = new InspAuthentication(id, null, null);
        authentication.setHighestAuth(true);
        return authentication;
    }

    private List<String> defaultEmptyListIfNull(List<String> source) {
        return null == source ? Collections.emptyList() : source;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getFuncAuthorities() {
        return this.funcAuthorities;
    }

    public List<String> getDataAuthorities() {
        return this.dataAuthorities;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public boolean isHighestAuth() {
        return this.highestAuth;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setFuncAuthorities(List<String> funcAuthorities) {
        this.funcAuthorities = funcAuthorities;
    }

    public void setDataAuthorities(List<String> dataAuthorities) {
        this.dataAuthorities = dataAuthorities;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public void setHighestAuth(boolean highestAuth) {
        this.highestAuth = highestAuth;
    }
}

